/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class AnalyzeDocumentOptions
extends GenericModel {
    protected String projectId;
    protected String collectionId;
    protected InputStream file;
    protected String filename;
    protected String fileContentType;
    protected String metadata;

    protected AnalyzeDocumentOptions(Builder builder) {
        Validator.notEmpty((String)builder.projectId, (String)"projectId cannot be empty");
        Validator.notEmpty((String)builder.collectionId, (String)"collectionId cannot be empty");
        Validator.isTrue((builder.file == null || builder.filename != null ? 1 : 0) != 0, (String)"filename cannot be null if file is not null.");
        this.projectId = builder.projectId;
        this.collectionId = builder.collectionId;
        this.file = builder.file;
        this.filename = builder.filename;
        this.fileContentType = builder.fileContentType;
        this.metadata = builder.metadata;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String projectId() {
        return this.projectId;
    }

    public String collectionId() {
        return this.collectionId;
    }

    public InputStream file() {
        return this.file;
    }

    public String filename() {
        return this.filename;
    }

    public String fileContentType() {
        return this.fileContentType;
    }

    public String metadata() {
        return this.metadata;
    }

    public static class Builder {
        private String projectId;
        private String collectionId;
        private InputStream file;
        private String filename;
        private String fileContentType;
        private String metadata;

        private Builder(AnalyzeDocumentOptions analyzeDocumentOptions) {
            this.projectId = analyzeDocumentOptions.projectId;
            this.collectionId = analyzeDocumentOptions.collectionId;
            this.file = analyzeDocumentOptions.file;
            this.filename = analyzeDocumentOptions.filename;
            this.fileContentType = analyzeDocumentOptions.fileContentType;
            this.metadata = analyzeDocumentOptions.metadata;
        }

        public Builder() {
        }

        public Builder(String projectId, String collectionId) {
            this.projectId = projectId;
            this.collectionId = collectionId;
        }

        public AnalyzeDocumentOptions build() {
            return new AnalyzeDocumentOptions(this);
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public Builder file(InputStream file) {
            this.file = file;
            return this;
        }

        public Builder filename(String filename) {
            this.filename = filename;
            return this;
        }

        public Builder fileContentType(String fileContentType) {
            this.fileContentType = fileContentType;
            return this;
        }

        public Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder file(File file) throws FileNotFoundException {
            this.file = new FileInputStream(file);
            this.filename = file.getName();
            return this;
        }
    }
}

