/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v2.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.discovery.v2.model.DefaultQueryParamsPassages;
import com.ibm.watson.discovery.v2.model.DefaultQueryParamsSuggestedRefinements;
import com.ibm.watson.discovery.v2.model.DefaultQueryParamsTableResults;
import java.util.ArrayList;
import java.util.List;

public class DefaultQueryParams
extends GenericModel {
    @SerializedName(value="collection_ids")
    protected List<String> collectionIds;
    protected DefaultQueryParamsPassages passages;
    @SerializedName(value="table_results")
    protected DefaultQueryParamsTableResults tableResults;
    protected String aggregation;
    @SerializedName(value="suggested_refinements")
    protected DefaultQueryParamsSuggestedRefinements suggestedRefinements;
    @SerializedName(value="spelling_suggestions")
    protected Boolean spellingSuggestions;
    protected Boolean highlight;
    protected Long count;
    protected String sort;
    @SerializedName(value="return")
    protected List<String> xReturn;

    protected DefaultQueryParams(Builder builder) {
        this.collectionIds = builder.collectionIds;
        this.passages = builder.passages;
        this.tableResults = builder.tableResults;
        this.aggregation = builder.aggregation;
        this.suggestedRefinements = builder.suggestedRefinements;
        this.spellingSuggestions = builder.spellingSuggestions;
        this.highlight = builder.highlight;
        this.count = builder.count;
        this.sort = builder.sort;
        this.xReturn = builder.xReturn;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public List<String> collectionIds() {
        return this.collectionIds;
    }

    public DefaultQueryParamsPassages passages() {
        return this.passages;
    }

    public DefaultQueryParamsTableResults tableResults() {
        return this.tableResults;
    }

    public String aggregation() {
        return this.aggregation;
    }

    public DefaultQueryParamsSuggestedRefinements suggestedRefinements() {
        return this.suggestedRefinements;
    }

    public Boolean spellingSuggestions() {
        return this.spellingSuggestions;
    }

    public Boolean highlight() {
        return this.highlight;
    }

    public Long count() {
        return this.count;
    }

    public String sort() {
        return this.sort;
    }

    public List<String> xReturn() {
        return this.xReturn;
    }

    public static class Builder {
        private List<String> collectionIds;
        private DefaultQueryParamsPassages passages;
        private DefaultQueryParamsTableResults tableResults;
        private String aggregation;
        private DefaultQueryParamsSuggestedRefinements suggestedRefinements;
        private Boolean spellingSuggestions;
        private Boolean highlight;
        private Long count;
        private String sort;
        private List<String> xReturn;

        private Builder(DefaultQueryParams defaultQueryParams) {
            this.collectionIds = defaultQueryParams.collectionIds;
            this.passages = defaultQueryParams.passages;
            this.tableResults = defaultQueryParams.tableResults;
            this.aggregation = defaultQueryParams.aggregation;
            this.suggestedRefinements = defaultQueryParams.suggestedRefinements;
            this.spellingSuggestions = defaultQueryParams.spellingSuggestions;
            this.highlight = defaultQueryParams.highlight;
            this.count = defaultQueryParams.count;
            this.sort = defaultQueryParams.sort;
            this.xReturn = defaultQueryParams.xReturn;
        }

        public Builder() {
        }

        public DefaultQueryParams build() {
            return new DefaultQueryParams(this);
        }

        public Builder addCollectionIds(String collectionIds) {
            Validator.notNull((Object)collectionIds, (String)"collectionIds cannot be null");
            if (this.collectionIds == null) {
                this.collectionIds = new ArrayList<String>();
            }
            this.collectionIds.add(collectionIds);
            return this;
        }

        public Builder addXReturn(String xReturn) {
            Validator.notNull((Object)xReturn, (String)"xReturn cannot be null");
            if (this.xReturn == null) {
                this.xReturn = new ArrayList<String>();
            }
            this.xReturn.add(xReturn);
            return this;
        }

        public Builder collectionIds(List<String> collectionIds) {
            this.collectionIds = collectionIds;
            return this;
        }

        public Builder passages(DefaultQueryParamsPassages passages) {
            this.passages = passages;
            return this;
        }

        public Builder tableResults(DefaultQueryParamsTableResults tableResults) {
            this.tableResults = tableResults;
            return this;
        }

        public Builder aggregation(String aggregation) {
            this.aggregation = aggregation;
            return this;
        }

        public Builder suggestedRefinements(DefaultQueryParamsSuggestedRefinements suggestedRefinements) {
            this.suggestedRefinements = suggestedRefinements;
            return this;
        }

        public Builder spellingSuggestions(Boolean spellingSuggestions) {
            this.spellingSuggestions = spellingSuggestions;
            return this;
        }

        public Builder highlight(Boolean highlight) {
            this.highlight = highlight;
            return this;
        }

        public Builder count(long count) {
            this.count = count;
            return this;
        }

        public Builder sort(String sort) {
            this.sort = sort;
            return this;
        }

        public Builder xReturn(List<String> xReturn) {
            this.xReturn = xReturn;
            return this;
        }
    }
}

