/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.discovery.v1.model.TokenDictRule;
import java.util.ArrayList;
import java.util.List;

public class CreateTokenizationDictionaryOptions
extends GenericModel {
    protected String environmentId;
    protected String collectionId;
    protected List<TokenDictRule> tokenizationRules;

    protected CreateTokenizationDictionaryOptions(Builder builder) {
        Validator.notEmpty((String)builder.environmentId, (String)"environmentId cannot be empty");
        Validator.notEmpty((String)builder.collectionId, (String)"collectionId cannot be empty");
        this.environmentId = builder.environmentId;
        this.collectionId = builder.collectionId;
        this.tokenizationRules = builder.tokenizationRules;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String collectionId() {
        return this.collectionId;
    }

    public List<TokenDictRule> tokenizationRules() {
        return this.tokenizationRules;
    }

    public static class Builder {
        private String environmentId;
        private String collectionId;
        private List<TokenDictRule> tokenizationRules;

        private Builder(CreateTokenizationDictionaryOptions createTokenizationDictionaryOptions) {
            this.environmentId = createTokenizationDictionaryOptions.environmentId;
            this.collectionId = createTokenizationDictionaryOptions.collectionId;
            this.tokenizationRules = createTokenizationDictionaryOptions.tokenizationRules;
        }

        public Builder() {
        }

        public Builder(String environmentId, String collectionId) {
            this.environmentId = environmentId;
            this.collectionId = collectionId;
        }

        public CreateTokenizationDictionaryOptions build() {
            return new CreateTokenizationDictionaryOptions(this);
        }

        public Builder addTokenizationRules(TokenDictRule tokenizationRules) {
            Validator.notNull((Object)((Object)tokenizationRules), (String)"tokenizationRules cannot be null");
            if (this.tokenizationRules == null) {
                this.tokenizationRules = new ArrayList<TokenDictRule>();
            }
            this.tokenizationRules.add(tokenizationRules);
            return this;
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public Builder tokenizationRules(List<TokenDictRule> tokenizationRules) {
            this.tokenizationRules = tokenizationRules;
            return this;
        }
    }
}

