/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v1.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.discovery.v1.model.XPathPatterns;
import java.util.ArrayList;
import java.util.List;

public class HtmlSettings
extends GenericModel {
    @SerializedName(value="exclude_tags_completely")
    protected List<String> excludeTagsCompletely;
    @SerializedName(value="exclude_tags_keep_content")
    protected List<String> excludeTagsKeepContent;
    @SerializedName(value="keep_content")
    protected XPathPatterns keepContent;
    @SerializedName(value="exclude_content")
    protected XPathPatterns excludeContent;
    @SerializedName(value="keep_tag_attributes")
    protected List<String> keepTagAttributes;
    @SerializedName(value="exclude_tag_attributes")
    protected List<String> excludeTagAttributes;

    protected HtmlSettings(Builder builder) {
        this.excludeTagsCompletely = builder.excludeTagsCompletely;
        this.excludeTagsKeepContent = builder.excludeTagsKeepContent;
        this.keepContent = builder.keepContent;
        this.excludeContent = builder.excludeContent;
        this.keepTagAttributes = builder.keepTagAttributes;
        this.excludeTagAttributes = builder.excludeTagAttributes;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public List<String> excludeTagsCompletely() {
        return this.excludeTagsCompletely;
    }

    public List<String> excludeTagsKeepContent() {
        return this.excludeTagsKeepContent;
    }

    public XPathPatterns keepContent() {
        return this.keepContent;
    }

    public XPathPatterns excludeContent() {
        return this.excludeContent;
    }

    public List<String> keepTagAttributes() {
        return this.keepTagAttributes;
    }

    public List<String> excludeTagAttributes() {
        return this.excludeTagAttributes;
    }

    public static class Builder {
        private List<String> excludeTagsCompletely;
        private List<String> excludeTagsKeepContent;
        private XPathPatterns keepContent;
        private XPathPatterns excludeContent;
        private List<String> keepTagAttributes;
        private List<String> excludeTagAttributes;

        private Builder(HtmlSettings htmlSettings) {
            this.excludeTagsCompletely = htmlSettings.excludeTagsCompletely;
            this.excludeTagsKeepContent = htmlSettings.excludeTagsKeepContent;
            this.keepContent = htmlSettings.keepContent;
            this.excludeContent = htmlSettings.excludeContent;
            this.keepTagAttributes = htmlSettings.keepTagAttributes;
            this.excludeTagAttributes = htmlSettings.excludeTagAttributes;
        }

        public Builder() {
        }

        public HtmlSettings build() {
            return new HtmlSettings(this);
        }

        public Builder addExcludeTagsCompletely(String excludeTagsCompletely) {
            Validator.notNull((Object)excludeTagsCompletely, (String)"excludeTagsCompletely cannot be null");
            if (this.excludeTagsCompletely == null) {
                this.excludeTagsCompletely = new ArrayList<String>();
            }
            this.excludeTagsCompletely.add(excludeTagsCompletely);
            return this;
        }

        public Builder addExcludeTagsKeepContent(String excludeTagsKeepContent) {
            Validator.notNull((Object)excludeTagsKeepContent, (String)"excludeTagsKeepContent cannot be null");
            if (this.excludeTagsKeepContent == null) {
                this.excludeTagsKeepContent = new ArrayList<String>();
            }
            this.excludeTagsKeepContent.add(excludeTagsKeepContent);
            return this;
        }

        public Builder addKeepTagAttributes(String keepTagAttributes) {
            Validator.notNull((Object)keepTagAttributes, (String)"keepTagAttributes cannot be null");
            if (this.keepTagAttributes == null) {
                this.keepTagAttributes = new ArrayList<String>();
            }
            this.keepTagAttributes.add(keepTagAttributes);
            return this;
        }

        public Builder addExcludeTagAttributes(String excludeTagAttributes) {
            Validator.notNull((Object)excludeTagAttributes, (String)"excludeTagAttributes cannot be null");
            if (this.excludeTagAttributes == null) {
                this.excludeTagAttributes = new ArrayList<String>();
            }
            this.excludeTagAttributes.add(excludeTagAttributes);
            return this;
        }

        public Builder excludeTagsCompletely(List<String> excludeTagsCompletely) {
            this.excludeTagsCompletely = excludeTagsCompletely;
            return this;
        }

        public Builder excludeTagsKeepContent(List<String> excludeTagsKeepContent) {
            this.excludeTagsKeepContent = excludeTagsKeepContent;
            return this;
        }

        public Builder keepContent(XPathPatterns keepContent) {
            this.keepContent = keepContent;
            return this;
        }

        public Builder excludeContent(XPathPatterns excludeContent) {
            this.excludeContent = excludeContent;
            return this;
        }

        public Builder keepTagAttributes(List<String> keepTagAttributes) {
            this.keepTagAttributes = keepTagAttributes;
            return this;
        }

        public Builder excludeTagAttributes(List<String> excludeTagAttributes) {
            this.excludeTagAttributes = excludeTagAttributes;
            return this;
        }
    }
}

