/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.discovery.v1.model.Configuration;
import com.ibm.watson.discovery.v1.model.Conversions;
import com.ibm.watson.discovery.v1.model.Enrichment;
import com.ibm.watson.discovery.v1.model.NormalizationOperation;
import com.ibm.watson.discovery.v1.model.Source;
import java.util.ArrayList;
import java.util.List;

public class UpdateConfigurationOptions
extends GenericModel {
    protected String environmentId;
    protected String configurationId;
    protected String name;
    protected String description;
    protected Conversions conversions;
    protected List<Enrichment> enrichments;
    protected List<NormalizationOperation> normalizations;
    protected Source source;

    protected UpdateConfigurationOptions(Builder builder) {
        Validator.notEmpty((String)builder.environmentId, (String)"environmentId cannot be empty");
        Validator.notEmpty((String)builder.configurationId, (String)"configurationId cannot be empty");
        Validator.notNull((Object)builder.name, (String)"name cannot be null");
        this.environmentId = builder.environmentId;
        this.configurationId = builder.configurationId;
        this.name = builder.name;
        this.description = builder.description;
        this.conversions = builder.conversions;
        this.enrichments = builder.enrichments;
        this.normalizations = builder.normalizations;
        this.source = builder.source;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String configurationId() {
        return this.configurationId;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public Conversions conversions() {
        return this.conversions;
    }

    public List<Enrichment> enrichments() {
        return this.enrichments;
    }

    public List<NormalizationOperation> normalizations() {
        return this.normalizations;
    }

    public Source source() {
        return this.source;
    }

    public static class Builder {
        private String environmentId;
        private String configurationId;
        private String name;
        private String description;
        private Conversions conversions;
        private List<Enrichment> enrichments;
        private List<NormalizationOperation> normalizations;
        private Source source;

        private Builder(UpdateConfigurationOptions updateConfigurationOptions) {
            this.environmentId = updateConfigurationOptions.environmentId;
            this.configurationId = updateConfigurationOptions.configurationId;
            this.name = updateConfigurationOptions.name;
            this.description = updateConfigurationOptions.description;
            this.conversions = updateConfigurationOptions.conversions;
            this.enrichments = updateConfigurationOptions.enrichments;
            this.normalizations = updateConfigurationOptions.normalizations;
            this.source = updateConfigurationOptions.source;
        }

        public Builder() {
        }

        public Builder(String environmentId, String configurationId, String name) {
            this.environmentId = environmentId;
            this.configurationId = configurationId;
            this.name = name;
        }

        public UpdateConfigurationOptions build() {
            return new UpdateConfigurationOptions(this);
        }

        public Builder addEnrichment(Enrichment enrichment) {
            Validator.notNull((Object)((Object)enrichment), (String)"enrichment cannot be null");
            if (this.enrichments == null) {
                this.enrichments = new ArrayList<Enrichment>();
            }
            this.enrichments.add(enrichment);
            return this;
        }

        public Builder addNormalization(NormalizationOperation normalization) {
            Validator.notNull((Object)((Object)normalization), (String)"normalization cannot be null");
            if (this.normalizations == null) {
                this.normalizations = new ArrayList<NormalizationOperation>();
            }
            this.normalizations.add(normalization);
            return this;
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public Builder configurationId(String configurationId) {
            this.configurationId = configurationId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder conversions(Conversions conversions) {
            this.conversions = conversions;
            return this;
        }

        public Builder enrichments(List<Enrichment> enrichments) {
            this.enrichments = enrichments;
            return this;
        }

        public Builder normalizations(List<NormalizationOperation> normalizations) {
            this.normalizations = normalizations;
            return this;
        }

        public Builder source(Source source) {
            this.source = source;
            return this;
        }

        public Builder configuration(Configuration configuration) {
            this.name = configuration.name();
            this.description = configuration.description();
            this.conversions = configuration.conversions();
            this.enrichments = configuration.enrichments();
            this.normalizations = configuration.normalizations();
            this.source = configuration.source();
            return this;
        }
    }
}

