/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v2.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class EnrichmentOptions
extends GenericModel {
    protected List<String> languages;
    @SerializedName(value="entity_type")
    protected String entityType;
    @SerializedName(value="regular_expression")
    protected String regularExpression;
    @SerializedName(value="result_field")
    protected String resultField;

    protected EnrichmentOptions(Builder builder) {
        this.languages = builder.languages;
        this.entityType = builder.entityType;
        this.regularExpression = builder.regularExpression;
        this.resultField = builder.resultField;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public List<String> languages() {
        return this.languages;
    }

    public String entityType() {
        return this.entityType;
    }

    public String regularExpression() {
        return this.regularExpression;
    }

    public String resultField() {
        return this.resultField;
    }

    public static class Builder {
        private List<String> languages;
        private String entityType;
        private String regularExpression;
        private String resultField;

        private Builder(EnrichmentOptions enrichmentOptions) {
            this.languages = enrichmentOptions.languages;
            this.entityType = enrichmentOptions.entityType;
            this.regularExpression = enrichmentOptions.regularExpression;
            this.resultField = enrichmentOptions.resultField;
        }

        public Builder() {
        }

        public EnrichmentOptions build() {
            return new EnrichmentOptions(this);
        }

        public Builder addLanguages(String languages) {
            Validator.notNull((Object)languages, (String)"languages cannot be null");
            if (this.languages == null) {
                this.languages = new ArrayList<String>();
            }
            this.languages.add(languages);
            return this;
        }

        public Builder languages(List<String> languages) {
            this.languages = languages;
            return this;
        }

        public Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        public Builder regularExpression(String regularExpression) {
            this.regularExpression = regularExpression;
            return this;
        }

        public Builder resultField(String resultField) {
            this.resultField = resultField;
            return this;
        }
    }
}

