/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class ListFieldsOptions
extends GenericModel {
    protected String projectId;
    protected List<String> collectionIds;

    protected ListFieldsOptions(Builder builder) {
        Validator.notEmpty((String)builder.projectId, (String)"projectId cannot be empty");
        this.projectId = builder.projectId;
        this.collectionIds = builder.collectionIds;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String projectId() {
        return this.projectId;
    }

    public List<String> collectionIds() {
        return this.collectionIds;
    }

    public static class Builder {
        private String projectId;
        private List<String> collectionIds;

        private Builder(ListFieldsOptions listFieldsOptions) {
            this.projectId = listFieldsOptions.projectId;
            this.collectionIds = listFieldsOptions.collectionIds;
        }

        public Builder() {
        }

        public Builder(String projectId) {
            this.projectId = projectId;
        }

        public ListFieldsOptions build() {
            return new ListFieldsOptions(this);
        }

        public Builder addCollectionIds(String collectionIds) {
            Validator.notNull((Object)collectionIds, (String)"collectionIds cannot be null");
            if (this.collectionIds == null) {
                this.collectionIds = new ArrayList<String>();
            }
            this.collectionIds.add(collectionIds);
            return this;
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder collectionIds(List<String> collectionIds) {
            this.collectionIds = collectionIds;
            return this;
        }
    }
}

