/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class QueryNoticesOptions
extends GenericModel {
    protected String projectId;
    protected String filter;
    protected String query;
    protected String naturalLanguageQuery;
    protected Long count;
    protected Long offset;

    protected QueryNoticesOptions(Builder builder) {
        Validator.notEmpty((String)builder.projectId, (String)"projectId cannot be empty");
        this.projectId = builder.projectId;
        this.filter = builder.filter;
        this.query = builder.query;
        this.naturalLanguageQuery = builder.naturalLanguageQuery;
        this.count = builder.count;
        this.offset = builder.offset;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String projectId() {
        return this.projectId;
    }

    public String filter() {
        return this.filter;
    }

    public String query() {
        return this.query;
    }

    public String naturalLanguageQuery() {
        return this.naturalLanguageQuery;
    }

    public Long count() {
        return this.count;
    }

    public Long offset() {
        return this.offset;
    }

    public static class Builder {
        private String projectId;
        private String filter;
        private String query;
        private String naturalLanguageQuery;
        private Long count;
        private Long offset;

        private Builder(QueryNoticesOptions queryNoticesOptions) {
            this.projectId = queryNoticesOptions.projectId;
            this.filter = queryNoticesOptions.filter;
            this.query = queryNoticesOptions.query;
            this.naturalLanguageQuery = queryNoticesOptions.naturalLanguageQuery;
            this.count = queryNoticesOptions.count;
            this.offset = queryNoticesOptions.offset;
        }

        public Builder() {
        }

        public Builder(String projectId) {
            this.projectId = projectId;
        }

        public QueryNoticesOptions build() {
            return new QueryNoticesOptions(this);
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public Builder query(String query) {
            this.query = query;
            return this;
        }

        public Builder naturalLanguageQuery(String naturalLanguageQuery) {
            this.naturalLanguageQuery = naturalLanguageQuery;
            return this;
        }

        public Builder count(long count) {
            this.count = count;
            return this;
        }

        public Builder offset(long offset) {
            this.offset = offset;
            return this;
        }
    }
}

