/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.discovery.v2.model.QueryLargePassages;
import com.ibm.watson.discovery.v2.model.QueryLargeSuggestedRefinements;
import com.ibm.watson.discovery.v2.model.QueryLargeTableResults;
import java.util.ArrayList;
import java.util.List;

public class QueryOptions
extends GenericModel {
    protected String projectId;
    protected List<String> collectionIds;
    protected String filter;
    protected String query;
    protected String naturalLanguageQuery;
    protected String aggregation;
    protected Long count;
    protected List<String> xReturn;
    protected Long offset;
    protected String sort;
    protected Boolean highlight;
    protected Boolean spellingSuggestions;
    protected QueryLargeTableResults tableResults;
    protected QueryLargeSuggestedRefinements suggestedRefinements;
    protected QueryLargePassages passages;

    protected QueryOptions(Builder builder) {
        Validator.notEmpty((String)builder.projectId, (String)"projectId cannot be empty");
        this.projectId = builder.projectId;
        this.collectionIds = builder.collectionIds;
        this.filter = builder.filter;
        this.query = builder.query;
        this.naturalLanguageQuery = builder.naturalLanguageQuery;
        this.aggregation = builder.aggregation;
        this.count = builder.count;
        this.xReturn = builder.xReturn;
        this.offset = builder.offset;
        this.sort = builder.sort;
        this.highlight = builder.highlight;
        this.spellingSuggestions = builder.spellingSuggestions;
        this.tableResults = builder.tableResults;
        this.suggestedRefinements = builder.suggestedRefinements;
        this.passages = builder.passages;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String projectId() {
        return this.projectId;
    }

    public List<String> collectionIds() {
        return this.collectionIds;
    }

    public String filter() {
        return this.filter;
    }

    public String query() {
        return this.query;
    }

    public String naturalLanguageQuery() {
        return this.naturalLanguageQuery;
    }

    public String aggregation() {
        return this.aggregation;
    }

    public Long count() {
        return this.count;
    }

    public List<String> xReturn() {
        return this.xReturn;
    }

    public Long offset() {
        return this.offset;
    }

    public String sort() {
        return this.sort;
    }

    public Boolean highlight() {
        return this.highlight;
    }

    public Boolean spellingSuggestions() {
        return this.spellingSuggestions;
    }

    public QueryLargeTableResults tableResults() {
        return this.tableResults;
    }

    public QueryLargeSuggestedRefinements suggestedRefinements() {
        return this.suggestedRefinements;
    }

    public QueryLargePassages passages() {
        return this.passages;
    }

    public static class Builder {
        private String projectId;
        private List<String> collectionIds;
        private String filter;
        private String query;
        private String naturalLanguageQuery;
        private String aggregation;
        private Long count;
        private List<String> xReturn;
        private Long offset;
        private String sort;
        private Boolean highlight;
        private Boolean spellingSuggestions;
        private QueryLargeTableResults tableResults;
        private QueryLargeSuggestedRefinements suggestedRefinements;
        private QueryLargePassages passages;

        private Builder(QueryOptions queryOptions) {
            this.projectId = queryOptions.projectId;
            this.collectionIds = queryOptions.collectionIds;
            this.filter = queryOptions.filter;
            this.query = queryOptions.query;
            this.naturalLanguageQuery = queryOptions.naturalLanguageQuery;
            this.aggregation = queryOptions.aggregation;
            this.count = queryOptions.count;
            this.xReturn = queryOptions.xReturn;
            this.offset = queryOptions.offset;
            this.sort = queryOptions.sort;
            this.highlight = queryOptions.highlight;
            this.spellingSuggestions = queryOptions.spellingSuggestions;
            this.tableResults = queryOptions.tableResults;
            this.suggestedRefinements = queryOptions.suggestedRefinements;
            this.passages = queryOptions.passages;
        }

        public Builder() {
        }

        public Builder(String projectId) {
            this.projectId = projectId;
        }

        public QueryOptions build() {
            return new QueryOptions(this);
        }

        public Builder addCollectionIds(String collectionIds) {
            Validator.notNull((Object)collectionIds, (String)"collectionIds cannot be null");
            if (this.collectionIds == null) {
                this.collectionIds = new ArrayList<String>();
            }
            this.collectionIds.add(collectionIds);
            return this;
        }

        public Builder addReturnField(String returnField) {
            Validator.notNull((Object)returnField, (String)"returnField cannot be null");
            if (this.xReturn == null) {
                this.xReturn = new ArrayList<String>();
            }
            this.xReturn.add(returnField);
            return this;
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder collectionIds(List<String> collectionIds) {
            this.collectionIds = collectionIds;
            return this;
        }

        public Builder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public Builder query(String query) {
            this.query = query;
            return this;
        }

        public Builder naturalLanguageQuery(String naturalLanguageQuery) {
            this.naturalLanguageQuery = naturalLanguageQuery;
            return this;
        }

        public Builder aggregation(String aggregation) {
            this.aggregation = aggregation;
            return this;
        }

        public Builder count(long count) {
            this.count = count;
            return this;
        }

        public Builder xReturn(List<String> xReturn) {
            this.xReturn = xReturn;
            return this;
        }

        public Builder offset(long offset) {
            this.offset = offset;
            return this;
        }

        public Builder sort(String sort) {
            this.sort = sort;
            return this;
        }

        public Builder highlight(Boolean highlight) {
            this.highlight = highlight;
            return this;
        }

        public Builder spellingSuggestions(Boolean spellingSuggestions) {
            this.spellingSuggestions = spellingSuggestions;
            return this;
        }

        public Builder tableResults(QueryLargeTableResults tableResults) {
            this.tableResults = tableResults;
            return this;
        }

        public Builder suggestedRefinements(QueryLargeSuggestedRefinements suggestedRefinements) {
            this.suggestedRefinements = suggestedRefinements;
            return this;
        }

        public Builder passages(QueryLargePassages passages) {
            this.passages = passages;
            return this;
        }
    }
}

