/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.discovery.v2.model.CollectionEnrichment;
import java.util.ArrayList;
import java.util.List;

public class UpdateCollectionOptions
extends GenericModel {
    protected String projectId;
    protected String collectionId;
    protected String name;
    protected String description;
    protected List<CollectionEnrichment> enrichments;

    protected UpdateCollectionOptions(Builder builder) {
        Validator.notEmpty((String)builder.projectId, (String)"projectId cannot be empty");
        Validator.notEmpty((String)builder.collectionId, (String)"collectionId cannot be empty");
        this.projectId = builder.projectId;
        this.collectionId = builder.collectionId;
        this.name = builder.name;
        this.description = builder.description;
        this.enrichments = builder.enrichments;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String projectId() {
        return this.projectId;
    }

    public String collectionId() {
        return this.collectionId;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public List<CollectionEnrichment> enrichments() {
        return this.enrichments;
    }

    public static class Builder {
        private String projectId;
        private String collectionId;
        private String name;
        private String description;
        private List<CollectionEnrichment> enrichments;

        private Builder(UpdateCollectionOptions updateCollectionOptions) {
            this.projectId = updateCollectionOptions.projectId;
            this.collectionId = updateCollectionOptions.collectionId;
            this.name = updateCollectionOptions.name;
            this.description = updateCollectionOptions.description;
            this.enrichments = updateCollectionOptions.enrichments;
        }

        public Builder() {
        }

        public Builder(String projectId, String collectionId) {
            this.projectId = projectId;
            this.collectionId = collectionId;
        }

        public UpdateCollectionOptions build() {
            return new UpdateCollectionOptions(this);
        }

        public Builder addEnrichments(CollectionEnrichment enrichments) {
            Validator.notNull((Object)((Object)enrichments), (String)"enrichments cannot be null");
            if (this.enrichments == null) {
                this.enrichments = new ArrayList<CollectionEnrichment>();
            }
            this.enrichments.add(enrichments);
            return this;
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder enrichments(List<CollectionEnrichment> enrichments) {
            this.enrichments = enrichments;
            return this;
        }
    }
}

