/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class UpdateDocumentOptions
extends GenericModel {
    protected String projectId;
    protected String collectionId;
    protected String documentId;
    protected InputStream file;
    protected String filename;
    protected String fileContentType;
    protected String metadata;
    protected Boolean xWatsonDiscoveryForce;

    protected UpdateDocumentOptions(Builder builder) {
        Validator.notEmpty((String)builder.projectId, (String)"projectId cannot be empty");
        Validator.notEmpty((String)builder.collectionId, (String)"collectionId cannot be empty");
        Validator.notEmpty((String)builder.documentId, (String)"documentId cannot be empty");
        Validator.isTrue((builder.file == null || builder.filename != null ? 1 : 0) != 0, (String)"filename cannot be null if file is not null.");
        this.projectId = builder.projectId;
        this.collectionId = builder.collectionId;
        this.documentId = builder.documentId;
        this.file = builder.file;
        this.filename = builder.filename;
        this.fileContentType = builder.fileContentType;
        this.metadata = builder.metadata;
        this.xWatsonDiscoveryForce = builder.xWatsonDiscoveryForce;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String projectId() {
        return this.projectId;
    }

    public String collectionId() {
        return this.collectionId;
    }

    public String documentId() {
        return this.documentId;
    }

    public InputStream file() {
        return this.file;
    }

    public String filename() {
        return this.filename;
    }

    public String fileContentType() {
        return this.fileContentType;
    }

    public String metadata() {
        return this.metadata;
    }

    public Boolean xWatsonDiscoveryForce() {
        return this.xWatsonDiscoveryForce;
    }

    public static class Builder {
        private String projectId;
        private String collectionId;
        private String documentId;
        private InputStream file;
        private String filename;
        private String fileContentType;
        private String metadata;
        private Boolean xWatsonDiscoveryForce;

        private Builder(UpdateDocumentOptions updateDocumentOptions) {
            this.projectId = updateDocumentOptions.projectId;
            this.collectionId = updateDocumentOptions.collectionId;
            this.documentId = updateDocumentOptions.documentId;
            this.file = updateDocumentOptions.file;
            this.filename = updateDocumentOptions.filename;
            this.fileContentType = updateDocumentOptions.fileContentType;
            this.metadata = updateDocumentOptions.metadata;
            this.xWatsonDiscoveryForce = updateDocumentOptions.xWatsonDiscoveryForce;
        }

        public Builder() {
        }

        public Builder(String projectId, String collectionId, String documentId) {
            this.projectId = projectId;
            this.collectionId = collectionId;
            this.documentId = documentId;
        }

        public UpdateDocumentOptions build() {
            return new UpdateDocumentOptions(this);
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public Builder documentId(String documentId) {
            this.documentId = documentId;
            return this;
        }

        public Builder file(InputStream file) {
            this.file = file;
            return this;
        }

        public Builder filename(String filename) {
            this.filename = filename;
            return this;
        }

        public Builder fileContentType(String fileContentType) {
            this.fileContentType = fileContentType;
            return this;
        }

        public Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder xWatsonDiscoveryForce(Boolean xWatsonDiscoveryForce) {
            this.xWatsonDiscoveryForce = xWatsonDiscoveryForce;
            return this;
        }

        public Builder file(File file) throws FileNotFoundException {
            this.file = new FileInputStream(file);
            this.filename = file.getName();
            return this;
        }
    }
}

