/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v1.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.discovery.v1.model.HtmlSettings;
import com.ibm.watson.discovery.v1.model.NormalizationOperation;
import com.ibm.watson.discovery.v1.model.PdfSettings;
import com.ibm.watson.discovery.v1.model.SegmentSettings;
import com.ibm.watson.discovery.v1.model.WordSettings;
import java.util.ArrayList;
import java.util.List;

public class Conversions
extends GenericModel {
    protected PdfSettings pdf;
    protected WordSettings word;
    protected HtmlSettings html;
    protected SegmentSettings segment;
    @SerializedName(value="json_normalizations")
    protected List<NormalizationOperation> jsonNormalizations;
    @SerializedName(value="image_text_recognition")
    protected Boolean imageTextRecognition;

    protected Conversions(Builder builder) {
        this.pdf = builder.pdf;
        this.word = builder.word;
        this.html = builder.html;
        this.segment = builder.segment;
        this.jsonNormalizations = builder.jsonNormalizations;
        this.imageTextRecognition = builder.imageTextRecognition;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public PdfSettings pdf() {
        return this.pdf;
    }

    public WordSettings word() {
        return this.word;
    }

    public HtmlSettings html() {
        return this.html;
    }

    public SegmentSettings segment() {
        return this.segment;
    }

    public List<NormalizationOperation> jsonNormalizations() {
        return this.jsonNormalizations;
    }

    public Boolean imageTextRecognition() {
        return this.imageTextRecognition;
    }

    public static class Builder {
        private PdfSettings pdf;
        private WordSettings word;
        private HtmlSettings html;
        private SegmentSettings segment;
        private List<NormalizationOperation> jsonNormalizations;
        private Boolean imageTextRecognition;

        private Builder(Conversions conversions) {
            this.pdf = conversions.pdf;
            this.word = conversions.word;
            this.html = conversions.html;
            this.segment = conversions.segment;
            this.jsonNormalizations = conversions.jsonNormalizations;
            this.imageTextRecognition = conversions.imageTextRecognition;
        }

        public Builder() {
        }

        public Conversions build() {
            return new Conversions(this);
        }

        public Builder addNormalization(NormalizationOperation normalization) {
            Validator.notNull((Object)((Object)normalization), (String)"normalization cannot be null");
            if (this.jsonNormalizations == null) {
                this.jsonNormalizations = new ArrayList<NormalizationOperation>();
            }
            this.jsonNormalizations.add(normalization);
            return this;
        }

        public Builder pdf(PdfSettings pdf) {
            this.pdf = pdf;
            return this;
        }

        public Builder word(WordSettings word) {
            this.word = word;
            return this;
        }

        public Builder html(HtmlSettings html) {
            this.html = html;
            return this;
        }

        public Builder segment(SegmentSettings segment) {
            this.segment = segment;
            return this;
        }

        public Builder jsonNormalizations(List<NormalizationOperation> jsonNormalizations) {
            this.jsonNormalizations = jsonNormalizations;
            return this;
        }

        public Builder imageTextRecognition(Boolean imageTextRecognition) {
            this.imageTextRecognition = imageTextRecognition;
            return this;
        }
    }
}

