/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v1.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.Date;

public class EventData
extends GenericModel {
    @SerializedName(value="environment_id")
    protected String environmentId;
    @SerializedName(value="session_token")
    protected String sessionToken;
    @SerializedName(value="client_timestamp")
    protected Date clientTimestamp;
    @SerializedName(value="display_rank")
    protected Long displayRank;
    @SerializedName(value="collection_id")
    protected String collectionId;
    @SerializedName(value="document_id")
    protected String documentId;
    @SerializedName(value="query_id")
    protected String queryId;

    protected EventData(Builder builder) {
        Validator.notNull((Object)builder.environmentId, (String)"environmentId cannot be null");
        Validator.notNull((Object)builder.sessionToken, (String)"sessionToken cannot be null");
        Validator.notNull((Object)builder.collectionId, (String)"collectionId cannot be null");
        Validator.notNull((Object)builder.documentId, (String)"documentId cannot be null");
        this.environmentId = builder.environmentId;
        this.sessionToken = builder.sessionToken;
        this.clientTimestamp = builder.clientTimestamp;
        this.displayRank = builder.displayRank;
        this.collectionId = builder.collectionId;
        this.documentId = builder.documentId;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String sessionToken() {
        return this.sessionToken;
    }

    public Date clientTimestamp() {
        return this.clientTimestamp;
    }

    public Long displayRank() {
        return this.displayRank;
    }

    public String collectionId() {
        return this.collectionId;
    }

    public String documentId() {
        return this.documentId;
    }

    public String queryId() {
        return this.queryId;
    }

    public static class Builder {
        private String environmentId;
        private String sessionToken;
        private Date clientTimestamp;
        private Long displayRank;
        private String collectionId;
        private String documentId;

        private Builder(EventData eventData) {
            this.environmentId = eventData.environmentId;
            this.sessionToken = eventData.sessionToken;
            this.clientTimestamp = eventData.clientTimestamp;
            this.displayRank = eventData.displayRank;
            this.collectionId = eventData.collectionId;
            this.documentId = eventData.documentId;
        }

        public Builder() {
        }

        public Builder(String environmentId, String sessionToken, String collectionId, String documentId) {
            this.environmentId = environmentId;
            this.sessionToken = sessionToken;
            this.collectionId = collectionId;
            this.documentId = documentId;
        }

        public EventData build() {
            return new EventData(this);
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public Builder sessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
            return this;
        }

        public Builder clientTimestamp(Date clientTimestamp) {
            this.clientTimestamp = clientTimestamp;
            return this;
        }

        public Builder displayRank(long displayRank) {
            this.displayRank = displayRank;
            return this;
        }

        public Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public Builder documentId(String documentId) {
            this.documentId = documentId;
            return this;
        }
    }
}

