/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class GetAutocompletionOptions
extends GenericModel {
    protected String environmentId;
    protected String collectionId;
    protected String prefix;
    protected String field;
    protected Long count;

    protected GetAutocompletionOptions(Builder builder) {
        Validator.notEmpty((String)builder.environmentId, (String)"environmentId cannot be empty");
        Validator.notEmpty((String)builder.collectionId, (String)"collectionId cannot be empty");
        Validator.notNull((Object)builder.prefix, (String)"prefix cannot be null");
        this.environmentId = builder.environmentId;
        this.collectionId = builder.collectionId;
        this.prefix = builder.prefix;
        this.field = builder.field;
        this.count = builder.count;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String collectionId() {
        return this.collectionId;
    }

    public String prefix() {
        return this.prefix;
    }

    public String field() {
        return this.field;
    }

    public Long count() {
        return this.count;
    }

    public static class Builder {
        private String environmentId;
        private String collectionId;
        private String prefix;
        private String field;
        private Long count;

        private Builder(GetAutocompletionOptions getAutocompletionOptions) {
            this.environmentId = getAutocompletionOptions.environmentId;
            this.collectionId = getAutocompletionOptions.collectionId;
            this.prefix = getAutocompletionOptions.prefix;
            this.field = getAutocompletionOptions.field;
            this.count = getAutocompletionOptions.count;
        }

        public Builder() {
        }

        public Builder(String environmentId, String collectionId, String prefix) {
            this.environmentId = environmentId;
            this.collectionId = collectionId;
            this.prefix = prefix;
        }

        public GetAutocompletionOptions build() {
            return new GetAutocompletionOptions(this);
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder field(String field) {
            this.field = field;
            return this;
        }

        public Builder count(long count) {
            this.count = count;
            return this;
        }
    }
}

