/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class UpdateCollectionOptions
extends GenericModel {
    protected String environmentId;
    protected String collectionId;
    protected String name;
    protected String description;
    protected String configurationId;

    protected UpdateCollectionOptions(Builder builder) {
        Validator.notEmpty((String)builder.environmentId, (String)"environmentId cannot be empty");
        Validator.notEmpty((String)builder.collectionId, (String)"collectionId cannot be empty");
        Validator.notNull((Object)builder.name, (String)"name cannot be null");
        this.environmentId = builder.environmentId;
        this.collectionId = builder.collectionId;
        this.name = builder.name;
        this.description = builder.description;
        this.configurationId = builder.configurationId;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String collectionId() {
        return this.collectionId;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String configurationId() {
        return this.configurationId;
    }

    public static class Builder {
        private String environmentId;
        private String collectionId;
        private String name;
        private String description;
        private String configurationId;

        private Builder(UpdateCollectionOptions updateCollectionOptions) {
            this.environmentId = updateCollectionOptions.environmentId;
            this.collectionId = updateCollectionOptions.collectionId;
            this.name = updateCollectionOptions.name;
            this.description = updateCollectionOptions.description;
            this.configurationId = updateCollectionOptions.configurationId;
        }

        public Builder() {
        }

        public Builder(String environmentId, String collectionId, String name) {
            this.environmentId = environmentId;
            this.collectionId = collectionId;
            this.name = name;
        }

        public UpdateCollectionOptions build() {
            return new UpdateCollectionOptions(this);
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder configurationId(String configurationId) {
            this.configurationId = configurationId;
            return this;
        }
    }
}

