/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.discovery.v1.model.CredentialDetails;
import com.ibm.watson.discovery.v1.model.Credentials;
import com.ibm.watson.discovery.v1.model.StatusDetails;

public class UpdateCredentialsOptions
extends GenericModel {
    protected String environmentId;
    protected String credentialId;
    protected String sourceType;
    protected CredentialDetails credentialDetails;
    protected StatusDetails status;

    protected UpdateCredentialsOptions(Builder builder) {
        Validator.notEmpty((String)builder.environmentId, (String)"environmentId cannot be empty");
        Validator.notEmpty((String)builder.credentialId, (String)"credentialId cannot be empty");
        this.environmentId = builder.environmentId;
        this.credentialId = builder.credentialId;
        this.sourceType = builder.sourceType;
        this.credentialDetails = builder.credentialDetails;
        this.status = builder.status;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String credentialId() {
        return this.credentialId;
    }

    public String sourceType() {
        return this.sourceType;
    }

    public CredentialDetails credentialDetails() {
        return this.credentialDetails;
    }

    public StatusDetails status() {
        return this.status;
    }

    public static class Builder {
        private String environmentId;
        private String credentialId;
        private String sourceType;
        private CredentialDetails credentialDetails;
        private StatusDetails status;

        private Builder(UpdateCredentialsOptions updateCredentialsOptions) {
            this.environmentId = updateCredentialsOptions.environmentId;
            this.credentialId = updateCredentialsOptions.credentialId;
            this.sourceType = updateCredentialsOptions.sourceType;
            this.credentialDetails = updateCredentialsOptions.credentialDetails;
            this.status = updateCredentialsOptions.status;
        }

        public Builder() {
        }

        public Builder(String environmentId, String credentialId) {
            this.environmentId = environmentId;
            this.credentialId = credentialId;
        }

        public UpdateCredentialsOptions build() {
            return new UpdateCredentialsOptions(this);
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public Builder credentialId(String credentialId) {
            this.credentialId = credentialId;
            return this;
        }

        public Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public Builder credentialDetails(CredentialDetails credentialDetails) {
            this.credentialDetails = credentialDetails;
            return this;
        }

        public Builder status(StatusDetails status) {
            this.status = status;
            return this;
        }

        public Builder credentials(Credentials credentials) {
            this.sourceType = credentials.sourceType();
            this.credentialDetails = credentials.credentialDetails();
            this.status = credentials.status();
            return this;
        }
    }

    public static interface SourceType {
        public static final String BOX = "box";
        public static final String SALESFORCE = "salesforce";
        public static final String SHAREPOINT = "sharepoint";
        public static final String WEB_CRAWL = "web_crawl";
        public static final String CLOUD_OBJECT_STORAGE = "cloud_object_storage";
    }
}

