/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class UpdateEnvironmentOptions
extends GenericModel {
    protected String environmentId;
    protected String name;
    protected String description;
    protected String size;

    protected UpdateEnvironmentOptions(Builder builder) {
        Validator.notEmpty((String)builder.environmentId, (String)"environmentId cannot be empty");
        this.environmentId = builder.environmentId;
        this.name = builder.name;
        this.description = builder.description;
        this.size = builder.size;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String environmentId() {
        return this.environmentId;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String size() {
        return this.size;
    }

    public static class Builder {
        private String environmentId;
        private String name;
        private String description;
        private String size;

        private Builder(UpdateEnvironmentOptions updateEnvironmentOptions) {
            this.environmentId = updateEnvironmentOptions.environmentId;
            this.name = updateEnvironmentOptions.name;
            this.description = updateEnvironmentOptions.description;
            this.size = updateEnvironmentOptions.size;
        }

        public Builder() {
        }

        public Builder(String environmentId) {
            this.environmentId = environmentId;
        }

        public UpdateEnvironmentOptions build() {
            return new UpdateEnvironmentOptions(this);
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder size(String size) {
            this.size = size;
            return this;
        }
    }

    public static interface Size {
        public static final String S = "S";
        public static final String MS = "MS";
        public static final String M = "M";
        public static final String ML = "ML";
        public static final String L = "L";
        public static final String XL = "XL";
        public static final String XXL = "XXL";
        public static final String XXXL = "XXXL";
    }
}

