/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v1.query;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.ibm.cloud.sdk.core.util.GsonSingleton;
import com.ibm.watson.discovery.v1.model.Calculation;
import com.ibm.watson.discovery.v1.model.Filter;
import com.ibm.watson.discovery.v1.model.Histogram;
import com.ibm.watson.discovery.v1.model.Nested;
import com.ibm.watson.discovery.v1.model.QueryAggregation;
import com.ibm.watson.discovery.v1.model.Term;
import com.ibm.watson.discovery.v1.model.Timeslice;
import com.ibm.watson.discovery.v1.model.TopHits;
import com.ibm.watson.discovery.v1.query.AggregationType;
import com.ibm.watson.discovery.v1.query.GenericQueryAggregation;
import java.lang.reflect.Type;

public class AggregationDeserializer
implements JsonDeserializer<QueryAggregation> {
    private static final String TYPE = "type";

    public QueryAggregation deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        String aggregationType = "";
        for (String key : jsonObject.keySet()) {
            if (!key.equals(TYPE)) continue;
            aggregationType = jsonObject.get(key).getAsString();
        }
        QueryAggregation aggregation = aggregationType.equals(AggregationType.HISTOGRAM.getName()) ? (QueryAggregation)((Object)GsonSingleton.getGson().fromJson(json, Histogram.class)) : (aggregationType.equals(AggregationType.MAX.getName()) || aggregationType.equals(AggregationType.MIN.getName()) || aggregationType.equals(AggregationType.AVERAGE.getName()) || aggregationType.equals(AggregationType.SUM.getName()) || aggregationType.equals(AggregationType.UNIQUE_COUNT.getName()) ? (QueryAggregation)((Object)GsonSingleton.getGson().fromJson(json, Calculation.class)) : (aggregationType.equals(AggregationType.TERM.getName()) ? (QueryAggregation)((Object)GsonSingleton.getGson().fromJson(json, Term.class)) : (aggregationType.equals(AggregationType.FILTER.getName()) ? (QueryAggregation)((Object)GsonSingleton.getGson().fromJson(json, Filter.class)) : (aggregationType.equals(AggregationType.NESTED.getName()) ? (QueryAggregation)((Object)GsonSingleton.getGson().fromJson(json, Nested.class)) : (aggregationType.equals(AggregationType.TIMESLICE.getName()) ? (QueryAggregation)((Object)GsonSingleton.getGson().fromJson(json, Timeslice.class)) : (aggregationType.equals(AggregationType.TOP_HITS.getName()) ? (QueryAggregation)((Object)GsonSingleton.getGson().fromJson(json, TopHits.class)) : (QueryAggregation)((Object)GsonSingleton.getGson().fromJson(json, GenericQueryAggregation.class))))))));
        return aggregation;
    }
}

