/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.discovery.v2.model.DefaultQueryParams;

public class CreateProjectOptions
extends GenericModel {
    protected String name;
    protected String type;
    protected DefaultQueryParams defaultQueryParameters;

    protected CreateProjectOptions(Builder builder) {
        Validator.notNull((Object)builder.name, (String)"name cannot be null");
        Validator.notNull((Object)builder.type, (String)"type cannot be null");
        this.name = builder.name;
        this.type = builder.type;
        this.defaultQueryParameters = builder.defaultQueryParameters;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public DefaultQueryParams defaultQueryParameters() {
        return this.defaultQueryParameters;
    }

    public static class Builder {
        private String name;
        private String type;
        private DefaultQueryParams defaultQueryParameters;

        private Builder(CreateProjectOptions createProjectOptions) {
            this.name = createProjectOptions.name;
            this.type = createProjectOptions.type;
            this.defaultQueryParameters = createProjectOptions.defaultQueryParameters;
        }

        public Builder() {
        }

        public Builder(String name, String type) {
            this.name = name;
            this.type = type;
        }

        public CreateProjectOptions build() {
            return new CreateProjectOptions(this);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder defaultQueryParameters(DefaultQueryParams defaultQueryParameters) {
            this.defaultQueryParameters = defaultQueryParameters;
            return this;
        }
    }

    public static interface Type {
        public static final String DOCUMENT_RETRIEVAL = "document_retrieval";
        public static final String CONVERSATIONAL_SEARCH = "conversational_search";
        public static final String CONTENT_INTELLIGENCE = "content_intelligence";
        public static final String CONTENT_MINING = "content_mining";
        public static final String OTHER = "other";
    }
}

