/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v2.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class UpdateEnrichmentOptions
extends GenericModel {
    protected String projectId;
    protected String enrichmentId;
    protected String name;
    protected String description;

    protected UpdateEnrichmentOptions(Builder builder) {
        Validator.notEmpty((String)builder.projectId, (String)"projectId cannot be empty");
        Validator.notEmpty((String)builder.enrichmentId, (String)"enrichmentId cannot be empty");
        Validator.notNull((Object)builder.name, (String)"name cannot be null");
        this.projectId = builder.projectId;
        this.enrichmentId = builder.enrichmentId;
        this.name = builder.name;
        this.description = builder.description;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String projectId() {
        return this.projectId;
    }

    public String enrichmentId() {
        return this.enrichmentId;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public static class Builder {
        private String projectId;
        private String enrichmentId;
        private String name;
        private String description;

        private Builder(UpdateEnrichmentOptions updateEnrichmentOptions) {
            this.projectId = updateEnrichmentOptions.projectId;
            this.enrichmentId = updateEnrichmentOptions.enrichmentId;
            this.name = updateEnrichmentOptions.name;
            this.description = updateEnrichmentOptions.description;
        }

        public Builder() {
        }

        public Builder(String projectId, String enrichmentId, String name) {
            this.projectId = projectId;
            this.enrichmentId = enrichmentId;
            this.name = name;
        }

        public UpdateEnrichmentOptions build() {
            return new UpdateEnrichmentOptions(this);
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder enrichmentId(String enrichmentId) {
            this.enrichmentId = enrichmentId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }
    }
}

