/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.discovery.v2.query;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.ibm.cloud.sdk.core.util.GsonSingleton;
import com.ibm.watson.discovery.query.AggregationType;
import com.ibm.watson.discovery.v2.model.QueryAggregation;
import com.ibm.watson.discovery.v2.model.QueryCalculationAggregation;
import com.ibm.watson.discovery.v2.model.QueryFilterAggregation;
import com.ibm.watson.discovery.v2.model.QueryHistogramAggregation;
import com.ibm.watson.discovery.v2.model.QueryNestedAggregation;
import com.ibm.watson.discovery.v2.model.QueryTermAggregation;
import com.ibm.watson.discovery.v2.model.QueryTimesliceAggregation;
import com.ibm.watson.discovery.v2.model.QueryTopHitsAggregation;
import com.ibm.watson.discovery.v2.query.GenericQueryAggregation;
import java.lang.reflect.Type;

public class AggregationDeserializer
implements JsonDeserializer<QueryAggregation> {
    private static final String TYPE = "type";

    public QueryAggregation deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        String aggregationType = "";
        for (String key : jsonObject.keySet()) {
            if (!key.equals(TYPE)) continue;
            aggregationType = jsonObject.get(key).getAsString();
        }
        QueryAggregation aggregation = aggregationType.equals(AggregationType.HISTOGRAM.getName()) ? (QueryAggregation)((Object)GsonSingleton.getGson().fromJson(json, QueryHistogramAggregation.class)) : (aggregationType.equals(AggregationType.MAX.getName()) || aggregationType.equals(AggregationType.MIN.getName()) || aggregationType.equals(AggregationType.AVERAGE.getName()) || aggregationType.equals(AggregationType.SUM.getName()) || aggregationType.equals(AggregationType.UNIQUE_COUNT.getName()) ? (QueryAggregation)((Object)GsonSingleton.getGson().fromJson(json, QueryCalculationAggregation.class)) : (aggregationType.equals(AggregationType.TERM.getName()) ? (QueryAggregation)((Object)GsonSingleton.getGson().fromJson(json, QueryTermAggregation.class)) : (aggregationType.equals(AggregationType.FILTER.getName()) ? (QueryAggregation)((Object)GsonSingleton.getGson().fromJson(json, QueryFilterAggregation.class)) : (aggregationType.equals(AggregationType.NESTED.getName()) ? (QueryAggregation)((Object)GsonSingleton.getGson().fromJson(json, QueryNestedAggregation.class)) : (aggregationType.equals(AggregationType.TIMESLICE.getName()) ? (QueryAggregation)((Object)GsonSingleton.getGson().fromJson(json, QueryTimesliceAggregation.class)) : (aggregationType.equals(AggregationType.TOP_HITS.getName()) ? (QueryAggregation)((Object)GsonSingleton.getGson().fromJson(json, QueryTopHitsAggregation.class)) : (QueryAggregation)((Object)GsonSingleton.getGson().fromJson(json, GenericQueryAggregation.class))))))));
        return aggregation;
    }
}

