/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.language_translator.v3;

import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.http.ResponseConverter;
import com.ibm.cloud.sdk.core.http.ServiceCall;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.ConfigBasedAuthenticatorFactory;
import com.ibm.cloud.sdk.core.service.BaseService;
import com.ibm.cloud.sdk.core.util.GsonSingleton;
import com.ibm.cloud.sdk.core.util.RequestUtils;
import com.ibm.cloud.sdk.core.util.ResponseConverterUtils;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.common.SdkCommon;
import com.ibm.watson.language_translator.v3.model.CreateModelOptions;
import com.ibm.watson.language_translator.v3.model.DeleteDocumentOptions;
import com.ibm.watson.language_translator.v3.model.DeleteModelOptions;
import com.ibm.watson.language_translator.v3.model.DeleteModelResult;
import com.ibm.watson.language_translator.v3.model.DocumentList;
import com.ibm.watson.language_translator.v3.model.DocumentStatus;
import com.ibm.watson.language_translator.v3.model.GetDocumentStatusOptions;
import com.ibm.watson.language_translator.v3.model.GetModelOptions;
import com.ibm.watson.language_translator.v3.model.GetTranslatedDocumentOptions;
import com.ibm.watson.language_translator.v3.model.IdentifiableLanguages;
import com.ibm.watson.language_translator.v3.model.IdentifiedLanguages;
import com.ibm.watson.language_translator.v3.model.IdentifyOptions;
import com.ibm.watson.language_translator.v3.model.ListDocumentsOptions;
import com.ibm.watson.language_translator.v3.model.ListIdentifiableLanguagesOptions;
import com.ibm.watson.language_translator.v3.model.ListModelsOptions;
import com.ibm.watson.language_translator.v3.model.TranslateDocumentOptions;
import com.ibm.watson.language_translator.v3.model.TranslateOptions;
import com.ibm.watson.language_translator.v3.model.TranslationModel;
import com.ibm.watson.language_translator.v3.model.TranslationModels;
import com.ibm.watson.language_translator.v3.model.TranslationResult;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public class LanguageTranslator
extends BaseService {
    private static final String SERVICE_NAME = "language_translator";
    private static final String SERVICE_URL = "https://gateway.watsonplatform.net/language-translator/api";
    private String versionDate;

    public LanguageTranslator(String versionDate) {
        this(versionDate, ConfigBasedAuthenticatorFactory.getAuthenticator((String)SERVICE_NAME));
    }

    public LanguageTranslator(String versionDate, Authenticator authenticator) {
        super(SERVICE_NAME, authenticator);
        if (this.getServiceUrl() == null || this.getServiceUrl().isEmpty()) {
            this.setServiceUrl(SERVICE_URL);
        }
        Validator.isTrue((versionDate != null && !versionDate.isEmpty() ? 1 : 0) != 0, (String)"version cannot be null.");
        this.versionDate = versionDate;
    }

    public ServiceCall<TranslationResult> translate(TranslateOptions translateOptions) {
        Validator.notNull((Object)((Object)translateOptions), (String)"translateOptions cannot be null");
        String[] pathSegments = new String[]{"v3/translate"};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v3", (String)"translate");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        contentJson.add("text", GsonSingleton.getGson().toJsonTree(translateOptions.text()));
        if (translateOptions.modelId() != null) {
            contentJson.addProperty("model_id", translateOptions.modelId());
        }
        if (translateOptions.source() != null) {
            contentJson.addProperty("source", translateOptions.source());
        }
        if (translateOptions.target() != null) {
            contentJson.addProperty("target", translateOptions.target());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<TranslationResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<IdentifiableLanguages> listIdentifiableLanguages(ListIdentifiableLanguagesOptions listIdentifiableLanguagesOptions) {
        String[] pathSegments = new String[]{"v3/identifiable_languages"};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v3", (String)"listIdentifiableLanguages");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (listIdentifiableLanguagesOptions != null) {
            // empty if block
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<IdentifiableLanguages>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<IdentifiableLanguages> listIdentifiableLanguages() {
        return this.listIdentifiableLanguages(null);
    }

    public ServiceCall<IdentifiedLanguages> identify(IdentifyOptions identifyOptions) {
        Validator.notNull((Object)((Object)identifyOptions), (String)"identifyOptions cannot be null");
        String[] pathSegments = new String[]{"v3/identify"};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v3", (String)"identify");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.bodyContent(identifyOptions.text(), "text/plain");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<IdentifiedLanguages>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<TranslationModels> listModels(ListModelsOptions listModelsOptions) {
        String[] pathSegments = new String[]{"v3/models"};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v3", (String)"listModels");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (listModelsOptions != null) {
            if (listModelsOptions.source() != null) {
                builder.query(new Object[]{"source", listModelsOptions.source()});
            }
            if (listModelsOptions.target() != null) {
                builder.query(new Object[]{"target", listModelsOptions.target()});
            }
            if (listModelsOptions.xDefault() != null) {
                builder.query(new Object[]{"default", String.valueOf(listModelsOptions.xDefault())});
            }
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<TranslationModels>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<TranslationModels> listModels() {
        return this.listModels(null);
    }

    public ServiceCall<TranslationModel> createModel(CreateModelOptions createModelOptions) {
        Validator.notNull((Object)((Object)createModelOptions), (String)"createModelOptions cannot be null");
        Validator.isTrue((createModelOptions.forcedGlossary() != null || createModelOptions.parallelCorpus() != null ? 1 : 0) != 0, (String)"At least one of forcedGlossary or parallelCorpus must be supplied.");
        String[] pathSegments = new String[]{"v3/models"};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v3", (String)"createModel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"base_model_id", createModelOptions.baseModelId()});
        if (createModelOptions.name() != null) {
            builder.query(new Object[]{"name", createModelOptions.name()});
        }
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
        multipartBuilder.setType(MultipartBody.FORM);
        if (createModelOptions.forcedGlossary() != null) {
            RequestBody forcedGlossaryBody = RequestUtils.inputStreamBody((InputStream)createModelOptions.forcedGlossary(), (String)"application/octet-stream");
            multipartBuilder.addFormDataPart("forced_glossary", "filename", forcedGlossaryBody);
        }
        if (createModelOptions.parallelCorpus() != null) {
            RequestBody parallelCorpusBody = RequestUtils.inputStreamBody((InputStream)createModelOptions.parallelCorpus(), (String)"application/octet-stream");
            multipartBuilder.addFormDataPart("parallel_corpus", "filename", parallelCorpusBody);
        }
        builder.body((RequestBody)multipartBuilder.build());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<TranslationModel>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DeleteModelResult> deleteModel(DeleteModelOptions deleteModelOptions) {
        Validator.notNull((Object)((Object)deleteModelOptions), (String)"deleteModelOptions cannot be null");
        String[] pathSegments = new String[]{"v3/models"};
        String[] pathParameters = new String[]{deleteModelOptions.modelId()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v3", (String)"deleteModel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DeleteModelResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<TranslationModel> getModel(GetModelOptions getModelOptions) {
        Validator.notNull((Object)((Object)getModelOptions), (String)"getModelOptions cannot be null");
        String[] pathSegments = new String[]{"v3/models"};
        String[] pathParameters = new String[]{getModelOptions.modelId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v3", (String)"getModel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<TranslationModel>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DocumentList> listDocuments(ListDocumentsOptions listDocumentsOptions) {
        String[] pathSegments = new String[]{"v3/documents"};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v3", (String)"listDocuments");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (listDocumentsOptions != null) {
            // empty if block
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DocumentList>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DocumentList> listDocuments() {
        return this.listDocuments(null);
    }

    public ServiceCall<DocumentStatus> translateDocument(TranslateDocumentOptions translateDocumentOptions) {
        Validator.notNull((Object)((Object)translateDocumentOptions), (String)"translateDocumentOptions cannot be null");
        String[] pathSegments = new String[]{"v3/documents"};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v3", (String)"translateDocument");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
        multipartBuilder.setType(MultipartBody.FORM);
        RequestBody fileBody = RequestUtils.inputStreamBody((InputStream)translateDocumentOptions.file(), (String)translateDocumentOptions.fileContentType());
        multipartBuilder.addFormDataPart("file", translateDocumentOptions.filename(), fileBody);
        if (translateDocumentOptions.modelId() != null) {
            multipartBuilder.addFormDataPart("model_id", translateDocumentOptions.modelId());
        }
        if (translateDocumentOptions.source() != null) {
            multipartBuilder.addFormDataPart("source", translateDocumentOptions.source());
        }
        if (translateDocumentOptions.target() != null) {
            multipartBuilder.addFormDataPart("target", translateDocumentOptions.target());
        }
        if (translateDocumentOptions.documentId() != null) {
            multipartBuilder.addFormDataPart("document_id", translateDocumentOptions.documentId());
        }
        builder.body((RequestBody)multipartBuilder.build());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DocumentStatus>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DocumentStatus> getDocumentStatus(GetDocumentStatusOptions getDocumentStatusOptions) {
        Validator.notNull((Object)((Object)getDocumentStatusOptions), (String)"getDocumentStatusOptions cannot be null");
        String[] pathSegments = new String[]{"v3/documents"};
        String[] pathParameters = new String[]{getDocumentStatusOptions.documentId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v3", (String)"getDocumentStatus");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DocumentStatus>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteDocument(DeleteDocumentOptions deleteDocumentOptions) {
        Validator.notNull((Object)((Object)deleteDocumentOptions), (String)"deleteDocumentOptions cannot be null");
        String[] pathSegments = new String[]{"v3/documents"};
        String[] pathParameters = new String[]{deleteDocumentOptions.documentId()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v3", (String)"deleteDocument");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InputStream> getTranslatedDocument(GetTranslatedDocumentOptions getTranslatedDocumentOptions) {
        Validator.notNull((Object)((Object)getTranslatedDocumentOptions), (String)"getTranslatedDocumentOptions cannot be null");
        String[] pathSegments = new String[]{"v3/documents", "translated_document"};
        String[] pathParameters = new String[]{getTranslatedDocumentOptions.documentId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)SERVICE_NAME, (String)"v3", (String)"getTranslatedDocument");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        if (getTranslatedDocumentOptions.accept() != null) {
            builder.header(new Object[]{"Accept", getTranslatedDocumentOptions.accept()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getInputStream();
        return this.createServiceCall(builder.build(), responseConverter);
    }
}

