/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.language_translator.v3.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class TranslateDocumentOptions
extends GenericModel {
    private InputStream file;
    private String filename;
    private String fileContentType;
    private String modelId;
    private String source;
    private String target;
    private String documentId;

    private TranslateDocumentOptions(Builder builder) {
        Validator.notNull((Object)builder.file, (String)"file cannot be null");
        Validator.notNull((Object)builder.filename, (String)"filename cannot be null");
        this.file = builder.file;
        this.filename = builder.filename;
        this.fileContentType = builder.fileContentType;
        this.modelId = builder.modelId;
        this.source = builder.source;
        this.target = builder.target;
        this.documentId = builder.documentId;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public InputStream file() {
        return this.file;
    }

    public String filename() {
        return this.filename;
    }

    public String fileContentType() {
        return this.fileContentType;
    }

    public String modelId() {
        return this.modelId;
    }

    public String source() {
        return this.source;
    }

    public String target() {
        return this.target;
    }

    public String documentId() {
        return this.documentId;
    }

    public static class Builder {
        private InputStream file;
        private String filename;
        private String fileContentType;
        private String modelId;
        private String source;
        private String target;
        private String documentId;

        private Builder(TranslateDocumentOptions translateDocumentOptions) {
            this.file = translateDocumentOptions.file;
            this.filename = translateDocumentOptions.filename;
            this.fileContentType = translateDocumentOptions.fileContentType;
            this.modelId = translateDocumentOptions.modelId;
            this.source = translateDocumentOptions.source;
            this.target = translateDocumentOptions.target;
            this.documentId = translateDocumentOptions.documentId;
        }

        public Builder() {
        }

        public Builder(InputStream file, String filename) {
            this.file = file;
            this.filename = filename;
        }

        public TranslateDocumentOptions build() {
            return new TranslateDocumentOptions(this);
        }

        public Builder file(InputStream file) {
            this.file = file;
            return this;
        }

        public Builder filename(String filename) {
            this.filename = filename;
            return this;
        }

        public Builder fileContentType(String fileContentType) {
            this.fileContentType = fileContentType;
            return this;
        }

        public Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public Builder source(String source) {
            this.source = source;
            return this;
        }

        public Builder target(String target) {
            this.target = target;
            return this;
        }

        public Builder documentId(String documentId) {
            this.documentId = documentId;
            return this;
        }

        public Builder file(File file) throws FileNotFoundException {
            this.file = new FileInputStream(file);
            this.filename = file.getName();
            return this;
        }
    }
}

