/*
 * (C) Copyright IBM Corp. 2017, 2019.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package com.ibm.watson.language_translator.v3.util;

import com.ibm.watson.language_translator.v3.LanguageTranslator;

/**
 * The languages available in {@link LanguageTranslator}.
 */

public interface Language {
  /** Afrikaans. */
  String AFRIKAANS = "af";

  /** Arabic. */
  String ARABIC = "ar";

  /** Azerbaijani. */
  String AZERBAIJANI = "az";

  /** Bashkir. */
  String BASHKIR = "ba";

  /** Belarusian. */
  String BELARUSIAN = "be";

  /** Bulgarian. */
  String BULGARIAN = "bg";

  /** Bengali. */
  String BENGALI = "bn";

  /** Bosnian. */
  String BOSNIAN = "bs";

  /** Czech. */
  String CZECH = "cs";

  /** Chuvash. */
  String CHUVASH = "cv";

  /** Danish. */
  String DANISH = "da";

  /** German. */
  String GERMAN = "de";

  /** Greek. */
  String GREEK = "el";

  /** English. */
  String ENGLISH = "en";

  /** Esperanto. */
  String ESPERANTO = "eo";

  /** Spanish. */
  String SPANISH = "es";

  /** Estonian. */
  String ESTONIAN = "et";

  /** Basque. */
  String BASQUE = "eu";

  /** Persian. */
  String PERSIAN = "fa";

  /** Finnish. */
  String FINNISH = "fi";

  /** French. */
  String FRENCH = "fr";

  /** Gujarati. */
  String GUJARATI = "gu";

  /** Hebrew. */
  String HEBREW = "he";

  /** Hindi. */
  String HINDI = "hi";

  /** Haitian. */
  String HAITIAN = "ht";

  /** Hungarian. */
  String HUNGARIAN = "hu";

  /** Armenian. */
  String ARMENIAN = "hy";

  /** Indonesian. */
  String INDONESIAN = "id";

  /** Icelandic. */
  String ICELANDIC = "is";

  /** Italian. */
  String ITALIAN = "it";

  /** Japanese. */
  String JAPANESE = "ja";

  /** Georgian. */
  String GEORGIAN = "ka";

  /** Kazakh. */
  String KAZAKH = "kk";

  /** Central Khmer. */
  String CENTRAL_KHMER = "km";

  /** Korean. */
  String KOREAN = "ko";

  /** Kurdish. */
  String KURDISH = "ku";

  /** Kirghiz. */
  String KIRGHIZ = "ky";

  /** Lithuanian. */
  String LITHUANIAN = "lt";

  /** Latvian. */
  String LATVIAN = "lv";

  /** Malayalam. */
  String MALAYALAM = "ml";

  /** Mongolian. */
  String MONGOLIAN = "mn";

  /** Norwegian Bokmal. */
  String NORWEGIAN_BOKMAL = "nb";

  /** Dutch. */
  String DUTCH = "nl";

  /** Norwegian Nynorsk. */
  String NORWEGIAN_NYNORSK = "nn";

  /** Panjabi. */
  String PANJABI = "pa";

  /** Polish. */
  String POLISH = "pl";

  /** Pushto. */
  String PUSHTO = "ps";

  /** Portuguese. */
  String PORTUGUESE = "pt";

  /** Romanian. */
  String ROMANIAN = "ro";

  /** Russian. */
  String RUSSIAN = "ru";

  /** Slovakian. */
  String SLOVAKIAN = "sk";

  /** Somali. */
  String SOMALI = "so";

  /** Albanian. */
  String ALBANIAN = "sq";

  /** Swedish. */
  String SWEDISH = "sv";

  /** Tamil. */
  String TAMIL = "ta";

  /** Telugu. */
  String TELUGU = "te";

  /** Turkish. */
  String TURKISH = "tr";

  /** Ukrainian. */
  String UKRAINIAN = "uk";

  /** Urdu. */
  String URDU = "ur";

  /** Vietnamese. */
  String VIETNAMESE = "vi";

  /** Chinese. */
  String CHINESE = "zh";

  /** Traditional Chinese. */
  String TRADITIONAL_CHINESE = "zh-TW";
}
