/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.natural_language_classifier.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class ClassifyOptions
extends GenericModel {
    private String classifierId;
    private String text;

    private ClassifyOptions(Builder builder) {
        Validator.notEmpty((String)builder.classifierId, (String)"classifierId cannot be empty");
        Validator.notNull((Object)builder.text, (String)"text cannot be null");
        this.classifierId = builder.classifierId;
        this.text = builder.text;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String classifierId() {
        return this.classifierId;
    }

    public String text() {
        return this.text;
    }

    public static class Builder {
        private String classifierId;
        private String text;

        private Builder(ClassifyOptions classifyOptions) {
            this.classifierId = classifyOptions.classifierId;
            this.text = classifyOptions.text;
        }

        public Builder() {
        }

        public Builder(String classifierId, String text) {
            this.classifierId = classifierId;
            this.text = text;
        }

        public ClassifyOptions build() {
            return new ClassifyOptions(this);
        }

        public Builder classifierId(String classifierId) {
            this.classifierId = classifierId;
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }
    }
}

