/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.natural_language_classifier.v1;

import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.http.ResponseConverter;
import com.ibm.cloud.sdk.core.http.ServiceCall;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.ConfigBasedAuthenticatorFactory;
import com.ibm.cloud.sdk.core.service.BaseService;
import com.ibm.cloud.sdk.core.util.GsonSingleton;
import com.ibm.cloud.sdk.core.util.RequestUtils;
import com.ibm.cloud.sdk.core.util.ResponseConverterUtils;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.common.SdkCommon;
import com.ibm.watson.natural_language_classifier.v1.model.Classification;
import com.ibm.watson.natural_language_classifier.v1.model.ClassificationCollection;
import com.ibm.watson.natural_language_classifier.v1.model.Classifier;
import com.ibm.watson.natural_language_classifier.v1.model.ClassifierList;
import com.ibm.watson.natural_language_classifier.v1.model.ClassifyCollectionOptions;
import com.ibm.watson.natural_language_classifier.v1.model.ClassifyOptions;
import com.ibm.watson.natural_language_classifier.v1.model.CreateClassifierOptions;
import com.ibm.watson.natural_language_classifier.v1.model.DeleteClassifierOptions;
import com.ibm.watson.natural_language_classifier.v1.model.GetClassifierOptions;
import com.ibm.watson.natural_language_classifier.v1.model.ListClassifiersOptions;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public class NaturalLanguageClassifier
extends BaseService {
    private static final String DEFAULT_SERVICE_NAME = "natural_language_classifier";
    private static final String DEFAULT_SERVICE_URL = "https://gateway.watsonplatform.net/natural-language-classifier/api";

    public NaturalLanguageClassifier() {
        this(DEFAULT_SERVICE_NAME, ConfigBasedAuthenticatorFactory.getAuthenticator((String)DEFAULT_SERVICE_NAME));
    }

    public NaturalLanguageClassifier(Authenticator authenticator) {
        this(DEFAULT_SERVICE_NAME, authenticator);
    }

    public NaturalLanguageClassifier(String serviceName) {
        this(serviceName, ConfigBasedAuthenticatorFactory.getAuthenticator((String)serviceName));
    }

    public NaturalLanguageClassifier(String serviceName, Authenticator authenticator) {
        super(serviceName, authenticator);
        this.setServiceUrl(DEFAULT_SERVICE_URL);
        this.configureService(serviceName);
    }

    public ServiceCall<Classification> classify(ClassifyOptions classifyOptions) {
        Validator.notNull((Object)((Object)classifyOptions), (String)"classifyOptions cannot be null");
        String[] pathSegments = new String[]{"v1/classifiers", "classify"};
        String[] pathParameters = new String[]{classifyOptions.classifierId()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"classify");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("text", classifyOptions.text());
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Classification>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ClassificationCollection> classifyCollection(ClassifyCollectionOptions classifyCollectionOptions) {
        Validator.notNull((Object)((Object)classifyCollectionOptions), (String)"classifyCollectionOptions cannot be null");
        String[] pathSegments = new String[]{"v1/classifiers", "classify_collection"};
        String[] pathParameters = new String[]{classifyCollectionOptions.classifierId()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"classifyCollection");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        contentJson.add("collection", GsonSingleton.getGson().toJsonTree(classifyCollectionOptions.collection()));
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ClassificationCollection>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Classifier> createClassifier(CreateClassifierOptions createClassifierOptions) {
        Validator.notNull((Object)((Object)createClassifierOptions), (String)"createClassifierOptions cannot be null");
        String[] pathSegments = new String[]{"v1/classifiers"};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"createClassifier");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
        multipartBuilder.setType(MultipartBody.FORM);
        RequestBody trainingMetadataBody = RequestUtils.inputStreamBody((InputStream)createClassifierOptions.trainingMetadata(), (String)"application/json");
        multipartBuilder.addFormDataPart("training_metadata", "filename", trainingMetadataBody);
        RequestBody trainingDataBody = RequestUtils.inputStreamBody((InputStream)createClassifierOptions.trainingData(), (String)"text/csv");
        multipartBuilder.addFormDataPart("training_data", "filename", trainingDataBody);
        builder.body((RequestBody)multipartBuilder.build());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Classifier>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ClassifierList> listClassifiers(ListClassifiersOptions listClassifiersOptions) {
        String[] pathSegments = new String[]{"v1/classifiers"};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"listClassifiers");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (listClassifiersOptions != null) {
            // empty if block
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ClassifierList>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ClassifierList> listClassifiers() {
        return this.listClassifiers(null);
    }

    public ServiceCall<Classifier> getClassifier(GetClassifierOptions getClassifierOptions) {
        Validator.notNull((Object)((Object)getClassifierOptions), (String)"getClassifierOptions cannot be null");
        String[] pathSegments = new String[]{"v1/classifiers"};
        String[] pathParameters = new String[]{getClassifierOptions.classifierId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getClassifier");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Classifier>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteClassifier(DeleteClassifierOptions deleteClassifierOptions) {
        Validator.notNull((Object)((Object)deleteClassifierOptions), (String)"deleteClassifierOptions cannot be null");
        String[] pathSegments = new String[]{"v1/classifiers"};
        String[] pathParameters = new String[]{deleteClassifierOptions.classifierId()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"deleteClassifier");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }
}

