/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.natural_language_classifier.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class CreateClassifierOptions
extends GenericModel {
    protected InputStream trainingMetadata;
    protected InputStream trainingData;

    protected CreateClassifierOptions(Builder builder) {
        Validator.notNull((Object)builder.trainingMetadata, (String)"trainingMetadata cannot be null");
        Validator.notNull((Object)builder.trainingData, (String)"trainingData cannot be null");
        this.trainingMetadata = builder.trainingMetadata;
        this.trainingData = builder.trainingData;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public InputStream trainingMetadata() {
        return this.trainingMetadata;
    }

    public InputStream trainingData() {
        return this.trainingData;
    }

    public static class Builder {
        private InputStream trainingMetadata;
        private InputStream trainingData;

        private Builder(CreateClassifierOptions createClassifierOptions) {
            this.trainingMetadata = createClassifierOptions.trainingMetadata;
            this.trainingData = createClassifierOptions.trainingData;
        }

        public Builder() {
        }

        public Builder(InputStream trainingMetadata, InputStream trainingData) {
            this.trainingMetadata = trainingMetadata;
            this.trainingData = trainingData;
        }

        public CreateClassifierOptions build() {
            return new CreateClassifierOptions(this);
        }

        public Builder trainingMetadata(InputStream trainingMetadata) {
            this.trainingMetadata = trainingMetadata;
            return this;
        }

        public Builder trainingData(InputStream trainingData) {
            this.trainingData = trainingData;
            return this;
        }

        public Builder trainingMetadata(File trainingMetadata) throws FileNotFoundException {
            this.trainingMetadata = new FileInputStream(trainingMetadata);
            return this;
        }

        public Builder trainingData(File trainingData) throws FileNotFoundException {
            this.trainingData = new FileInputStream(trainingData);
            return this;
        }
    }
}

