/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.natural_language_understanding.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Map;

public class UpdateCategoriesModelOptions
extends GenericModel {
    protected String modelId;
    protected String language;
    protected InputStream trainingData;
    protected String trainingDataContentType;
    protected String name;
    protected Map<String, Object> userMetadata;
    protected String description;
    protected String modelVersion;
    protected String workspaceId;
    protected String versionDescription;

    protected UpdateCategoriesModelOptions(Builder builder) {
        Validator.notEmpty((String)builder.modelId, (String)"modelId cannot be empty");
        Validator.notNull((Object)builder.language, (String)"language cannot be null");
        Validator.notNull((Object)builder.trainingData, (String)"trainingData cannot be null");
        this.modelId = builder.modelId;
        this.language = builder.language;
        this.trainingData = builder.trainingData;
        this.trainingDataContentType = builder.trainingDataContentType;
        this.name = builder.name;
        this.userMetadata = builder.userMetadata;
        this.description = builder.description;
        this.modelVersion = builder.modelVersion;
        this.workspaceId = builder.workspaceId;
        this.versionDescription = builder.versionDescription;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String modelId() {
        return this.modelId;
    }

    public String language() {
        return this.language;
    }

    public InputStream trainingData() {
        return this.trainingData;
    }

    public String trainingDataContentType() {
        return this.trainingDataContentType;
    }

    public String name() {
        return this.name;
    }

    public Map<String, Object> userMetadata() {
        return this.userMetadata;
    }

    public String description() {
        return this.description;
    }

    public String modelVersion() {
        return this.modelVersion;
    }

    public String workspaceId() {
        return this.workspaceId;
    }

    public String versionDescription() {
        return this.versionDescription;
    }

    public static class Builder {
        private String modelId;
        private String language;
        private InputStream trainingData;
        private String trainingDataContentType;
        private String name;
        private Map<String, Object> userMetadata;
        private String description;
        private String modelVersion;
        private String workspaceId;
        private String versionDescription;

        private Builder(UpdateCategoriesModelOptions updateCategoriesModelOptions) {
            this.modelId = updateCategoriesModelOptions.modelId;
            this.language = updateCategoriesModelOptions.language;
            this.trainingData = updateCategoriesModelOptions.trainingData;
            this.trainingDataContentType = updateCategoriesModelOptions.trainingDataContentType;
            this.name = updateCategoriesModelOptions.name;
            this.userMetadata = updateCategoriesModelOptions.userMetadata;
            this.description = updateCategoriesModelOptions.description;
            this.modelVersion = updateCategoriesModelOptions.modelVersion;
            this.workspaceId = updateCategoriesModelOptions.workspaceId;
            this.versionDescription = updateCategoriesModelOptions.versionDescription;
        }

        public Builder() {
        }

        public Builder(String modelId, String language, InputStream trainingData) {
            this.modelId = modelId;
            this.language = language;
            this.trainingData = trainingData;
        }

        public UpdateCategoriesModelOptions build() {
            return new UpdateCategoriesModelOptions(this);
        }

        public Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            return this;
        }

        public Builder trainingData(InputStream trainingData) {
            this.trainingData = trainingData;
            return this;
        }

        public Builder trainingDataContentType(String trainingDataContentType) {
            this.trainingDataContentType = trainingDataContentType;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder userMetadata(Map<String, Object> userMetadata) {
            this.userMetadata = userMetadata;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder modelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder versionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
            return this;
        }

        public Builder trainingData(File trainingData) throws FileNotFoundException {
            this.trainingData = new FileInputStream(trainingData);
            return this;
        }
    }
}

