/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.natural_language_understanding.v1;

import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.http.ResponseConverter;
import com.ibm.cloud.sdk.core.http.ServiceCall;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.ConfigBasedAuthenticatorFactory;
import com.ibm.cloud.sdk.core.service.BaseService;
import com.ibm.cloud.sdk.core.util.GsonSingleton;
import com.ibm.cloud.sdk.core.util.RequestUtils;
import com.ibm.cloud.sdk.core.util.ResponseConverterUtils;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.common.SdkCommon;
import com.ibm.watson.natural_language_understanding.v1.model.AnalysisResults;
import com.ibm.watson.natural_language_understanding.v1.model.AnalyzeOptions;
import com.ibm.watson.natural_language_understanding.v1.model.CategoriesModel;
import com.ibm.watson.natural_language_understanding.v1.model.CategoriesModelList;
import com.ibm.watson.natural_language_understanding.v1.model.ClassificationsModel;
import com.ibm.watson.natural_language_understanding.v1.model.ClassificationsModelList;
import com.ibm.watson.natural_language_understanding.v1.model.CreateCategoriesModelOptions;
import com.ibm.watson.natural_language_understanding.v1.model.CreateClassificationsModelOptions;
import com.ibm.watson.natural_language_understanding.v1.model.CreateSentimentModelOptions;
import com.ibm.watson.natural_language_understanding.v1.model.DeleteCategoriesModelOptions;
import com.ibm.watson.natural_language_understanding.v1.model.DeleteClassificationsModelOptions;
import com.ibm.watson.natural_language_understanding.v1.model.DeleteModelOptions;
import com.ibm.watson.natural_language_understanding.v1.model.DeleteModelResults;
import com.ibm.watson.natural_language_understanding.v1.model.DeleteSentimentModelOptions;
import com.ibm.watson.natural_language_understanding.v1.model.GetCategoriesModelOptions;
import com.ibm.watson.natural_language_understanding.v1.model.GetClassificationsModelOptions;
import com.ibm.watson.natural_language_understanding.v1.model.GetSentimentModelOptions;
import com.ibm.watson.natural_language_understanding.v1.model.ListCategoriesModelsOptions;
import com.ibm.watson.natural_language_understanding.v1.model.ListClassificationsModelsOptions;
import com.ibm.watson.natural_language_understanding.v1.model.ListModelsOptions;
import com.ibm.watson.natural_language_understanding.v1.model.ListModelsResults;
import com.ibm.watson.natural_language_understanding.v1.model.ListSentimentModelsOptions;
import com.ibm.watson.natural_language_understanding.v1.model.ListSentimentModelsResponse;
import com.ibm.watson.natural_language_understanding.v1.model.SentimentModel;
import com.ibm.watson.natural_language_understanding.v1.model.UpdateCategoriesModelOptions;
import com.ibm.watson.natural_language_understanding.v1.model.UpdateClassificationsModelOptions;
import com.ibm.watson.natural_language_understanding.v1.model.UpdateSentimentModelOptions;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public class NaturalLanguageUnderstanding
extends BaseService {
    public static final String DEFAULT_SERVICE_NAME = "natural-language-understanding";
    public static final String DEFAULT_SERVICE_URL = "https://api.us-south.natural-language-understanding.watson.cloud.ibm.com";
    private String version;

    public NaturalLanguageUnderstanding(String version) {
        this(version, DEFAULT_SERVICE_NAME, ConfigBasedAuthenticatorFactory.getAuthenticator((String)DEFAULT_SERVICE_NAME));
    }

    public NaturalLanguageUnderstanding(String version, Authenticator authenticator) {
        this(version, DEFAULT_SERVICE_NAME, authenticator);
    }

    public NaturalLanguageUnderstanding(String version, String serviceName) {
        this(version, serviceName, ConfigBasedAuthenticatorFactory.getAuthenticator((String)serviceName));
    }

    public NaturalLanguageUnderstanding(String version, String serviceName, Authenticator authenticator) {
        super(serviceName, authenticator);
        this.setServiceUrl(DEFAULT_SERVICE_URL);
        this.setVersion(version);
        this.configureService(serviceName);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        Validator.notEmpty((String)version, (String)"version cannot be empty.");
        this.version = version;
    }

    public ServiceCall<AnalysisResults> analyze(AnalyzeOptions analyzeOptions) {
        Validator.notNull((Object)((Object)analyzeOptions), (String)"analyzeOptions cannot be null");
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/analyze"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"analyze");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        JsonObject contentJson = new JsonObject();
        contentJson.add("features", GsonSingleton.getGson().toJsonTree((Object)analyzeOptions.features()));
        if (analyzeOptions.text() != null) {
            contentJson.addProperty("text", analyzeOptions.text());
        }
        if (analyzeOptions.html() != null) {
            contentJson.addProperty("html", analyzeOptions.html());
        }
        if (analyzeOptions.url() != null) {
            contentJson.addProperty("url", analyzeOptions.url());
        }
        if (analyzeOptions.clean() != null) {
            contentJson.addProperty("clean", analyzeOptions.clean());
        }
        if (analyzeOptions.xpath() != null) {
            contentJson.addProperty("xpath", analyzeOptions.xpath());
        }
        if (analyzeOptions.fallbackToRaw() != null) {
            contentJson.addProperty("fallback_to_raw", analyzeOptions.fallbackToRaw());
        }
        if (analyzeOptions.returnAnalyzedText() != null) {
            contentJson.addProperty("return_analyzed_text", analyzeOptions.returnAnalyzedText());
        }
        if (analyzeOptions.language() != null) {
            contentJson.addProperty("language", analyzeOptions.language());
        }
        if (analyzeOptions.limitTextCharacters() != null) {
            contentJson.addProperty("limit_text_characters", (Number)analyzeOptions.limitTextCharacters());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<AnalysisResults>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ListModelsResults> listModels(ListModelsOptions listModelsOptions) {
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/models"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"listModels");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ListModelsResults>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ListModelsResults> listModels() {
        return this.listModels(null);
    }

    public ServiceCall<DeleteModelResults> deleteModel(DeleteModelOptions deleteModelOptions) {
        Validator.notNull((Object)((Object)deleteModelOptions), (String)"deleteModelOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("model_id", deleteModelOptions.modelId());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/models/{model_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"deleteModel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DeleteModelResults>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SentimentModel> createSentimentModel(CreateSentimentModelOptions createSentimentModelOptions) {
        Validator.notNull((Object)((Object)createSentimentModelOptions), (String)"createSentimentModelOptions cannot be null");
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/models/sentiment"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"createSentimentModel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
        multipartBuilder.setType(MultipartBody.FORM);
        multipartBuilder.addFormDataPart("language", createSentimentModelOptions.language());
        RequestBody trainingDataBody = RequestUtils.inputStreamBody((InputStream)createSentimentModelOptions.trainingData(), (String)"text/csv");
        multipartBuilder.addFormDataPart("training_data", "filename", trainingDataBody);
        if (createSentimentModelOptions.name() != null) {
            multipartBuilder.addFormDataPart("name", createSentimentModelOptions.name());
        }
        if (createSentimentModelOptions.description() != null) {
            multipartBuilder.addFormDataPart("description", createSentimentModelOptions.description());
        }
        if (createSentimentModelOptions.modelVersion() != null) {
            multipartBuilder.addFormDataPart("model_version", createSentimentModelOptions.modelVersion());
        }
        if (createSentimentModelOptions.workspaceId() != null) {
            multipartBuilder.addFormDataPart("workspace_id", createSentimentModelOptions.workspaceId());
        }
        if (createSentimentModelOptions.versionDescription() != null) {
            multipartBuilder.addFormDataPart("version_description", createSentimentModelOptions.versionDescription());
        }
        builder.body((RequestBody)multipartBuilder.build());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<SentimentModel>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ListSentimentModelsResponse> listSentimentModels(ListSentimentModelsOptions listSentimentModelsOptions) {
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/models/sentiment"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"listSentimentModels");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ListSentimentModelsResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ListSentimentModelsResponse> listSentimentModels() {
        return this.listSentimentModels(null);
    }

    public ServiceCall<SentimentModel> getSentimentModel(GetSentimentModelOptions getSentimentModelOptions) {
        Validator.notNull((Object)((Object)getSentimentModelOptions), (String)"getSentimentModelOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("model_id", getSentimentModelOptions.modelId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/models/sentiment/{model_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getSentimentModel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<SentimentModel>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SentimentModel> updateSentimentModel(UpdateSentimentModelOptions updateSentimentModelOptions) {
        Validator.notNull((Object)((Object)updateSentimentModelOptions), (String)"updateSentimentModelOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("model_id", updateSentimentModelOptions.modelId());
        RequestBuilder builder = RequestBuilder.put((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/models/sentiment/{model_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"updateSentimentModel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
        multipartBuilder.setType(MultipartBody.FORM);
        multipartBuilder.addFormDataPart("language", updateSentimentModelOptions.language());
        RequestBody trainingDataBody = RequestUtils.inputStreamBody((InputStream)updateSentimentModelOptions.trainingData(), (String)"text/csv");
        multipartBuilder.addFormDataPart("training_data", "filename", trainingDataBody);
        if (updateSentimentModelOptions.name() != null) {
            multipartBuilder.addFormDataPart("name", updateSentimentModelOptions.name());
        }
        if (updateSentimentModelOptions.description() != null) {
            multipartBuilder.addFormDataPart("description", updateSentimentModelOptions.description());
        }
        if (updateSentimentModelOptions.modelVersion() != null) {
            multipartBuilder.addFormDataPart("model_version", updateSentimentModelOptions.modelVersion());
        }
        if (updateSentimentModelOptions.workspaceId() != null) {
            multipartBuilder.addFormDataPart("workspace_id", updateSentimentModelOptions.workspaceId());
        }
        if (updateSentimentModelOptions.versionDescription() != null) {
            multipartBuilder.addFormDataPart("version_description", updateSentimentModelOptions.versionDescription());
        }
        builder.body((RequestBody)multipartBuilder.build());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<SentimentModel>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DeleteModelResults> deleteSentimentModel(DeleteSentimentModelOptions deleteSentimentModelOptions) {
        Validator.notNull((Object)((Object)deleteSentimentModelOptions), (String)"deleteSentimentModelOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("model_id", deleteSentimentModelOptions.modelId());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/models/sentiment/{model_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"deleteSentimentModel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DeleteModelResults>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<CategoriesModel> createCategoriesModel(CreateCategoriesModelOptions createCategoriesModelOptions) {
        Validator.notNull((Object)((Object)createCategoriesModelOptions), (String)"createCategoriesModelOptions cannot be null");
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/models/categories"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"createCategoriesModel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
        multipartBuilder.setType(MultipartBody.FORM);
        multipartBuilder.addFormDataPart("language", createCategoriesModelOptions.language());
        RequestBody trainingDataBody = RequestUtils.inputStreamBody((InputStream)createCategoriesModelOptions.trainingData(), (String)createCategoriesModelOptions.trainingDataContentType());
        multipartBuilder.addFormDataPart("training_data", "filename", trainingDataBody);
        if (createCategoriesModelOptions.name() != null) {
            multipartBuilder.addFormDataPart("name", createCategoriesModelOptions.name());
        }
        if (createCategoriesModelOptions.description() != null) {
            multipartBuilder.addFormDataPart("description", createCategoriesModelOptions.description());
        }
        if (createCategoriesModelOptions.modelVersion() != null) {
            multipartBuilder.addFormDataPart("model_version", createCategoriesModelOptions.modelVersion());
        }
        if (createCategoriesModelOptions.workspaceId() != null) {
            multipartBuilder.addFormDataPart("workspace_id", createCategoriesModelOptions.workspaceId());
        }
        if (createCategoriesModelOptions.versionDescription() != null) {
            multipartBuilder.addFormDataPart("version_description", createCategoriesModelOptions.versionDescription());
        }
        builder.body((RequestBody)multipartBuilder.build());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<CategoriesModel>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<CategoriesModelList> listCategoriesModels(ListCategoriesModelsOptions listCategoriesModelsOptions) {
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/models/categories"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"listCategoriesModels");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<CategoriesModelList>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<CategoriesModelList> listCategoriesModels() {
        return this.listCategoriesModels(null);
    }

    public ServiceCall<CategoriesModel> getCategoriesModel(GetCategoriesModelOptions getCategoriesModelOptions) {
        Validator.notNull((Object)((Object)getCategoriesModelOptions), (String)"getCategoriesModelOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("model_id", getCategoriesModelOptions.modelId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/models/categories/{model_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getCategoriesModel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<CategoriesModel>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<CategoriesModel> updateCategoriesModel(UpdateCategoriesModelOptions updateCategoriesModelOptions) {
        Validator.notNull((Object)((Object)updateCategoriesModelOptions), (String)"updateCategoriesModelOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("model_id", updateCategoriesModelOptions.modelId());
        RequestBuilder builder = RequestBuilder.put((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/models/categories/{model_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"updateCategoriesModel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
        multipartBuilder.setType(MultipartBody.FORM);
        multipartBuilder.addFormDataPart("language", updateCategoriesModelOptions.language());
        RequestBody trainingDataBody = RequestUtils.inputStreamBody((InputStream)updateCategoriesModelOptions.trainingData(), (String)updateCategoriesModelOptions.trainingDataContentType());
        multipartBuilder.addFormDataPart("training_data", "filename", trainingDataBody);
        if (updateCategoriesModelOptions.name() != null) {
            multipartBuilder.addFormDataPart("name", updateCategoriesModelOptions.name());
        }
        if (updateCategoriesModelOptions.description() != null) {
            multipartBuilder.addFormDataPart("description", updateCategoriesModelOptions.description());
        }
        if (updateCategoriesModelOptions.modelVersion() != null) {
            multipartBuilder.addFormDataPart("model_version", updateCategoriesModelOptions.modelVersion());
        }
        if (updateCategoriesModelOptions.workspaceId() != null) {
            multipartBuilder.addFormDataPart("workspace_id", updateCategoriesModelOptions.workspaceId());
        }
        if (updateCategoriesModelOptions.versionDescription() != null) {
            multipartBuilder.addFormDataPart("version_description", updateCategoriesModelOptions.versionDescription());
        }
        builder.body((RequestBody)multipartBuilder.build());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<CategoriesModel>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DeleteModelResults> deleteCategoriesModel(DeleteCategoriesModelOptions deleteCategoriesModelOptions) {
        Validator.notNull((Object)((Object)deleteCategoriesModelOptions), (String)"deleteCategoriesModelOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("model_id", deleteCategoriesModelOptions.modelId());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/models/categories/{model_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"deleteCategoriesModel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DeleteModelResults>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ClassificationsModel> createClassificationsModel(CreateClassificationsModelOptions createClassificationsModelOptions) {
        Validator.notNull((Object)((Object)createClassificationsModelOptions), (String)"createClassificationsModelOptions cannot be null");
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/models/classifications"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"createClassificationsModel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
        multipartBuilder.setType(MultipartBody.FORM);
        multipartBuilder.addFormDataPart("language", createClassificationsModelOptions.language());
        RequestBody trainingDataBody = RequestUtils.inputStreamBody((InputStream)createClassificationsModelOptions.trainingData(), (String)createClassificationsModelOptions.trainingDataContentType());
        multipartBuilder.addFormDataPart("training_data", "filename", trainingDataBody);
        if (createClassificationsModelOptions.name() != null) {
            multipartBuilder.addFormDataPart("name", createClassificationsModelOptions.name());
        }
        if (createClassificationsModelOptions.description() != null) {
            multipartBuilder.addFormDataPart("description", createClassificationsModelOptions.description());
        }
        if (createClassificationsModelOptions.modelVersion() != null) {
            multipartBuilder.addFormDataPart("model_version", createClassificationsModelOptions.modelVersion());
        }
        if (createClassificationsModelOptions.workspaceId() != null) {
            multipartBuilder.addFormDataPart("workspace_id", createClassificationsModelOptions.workspaceId());
        }
        if (createClassificationsModelOptions.versionDescription() != null) {
            multipartBuilder.addFormDataPart("version_description", createClassificationsModelOptions.versionDescription());
        }
        if (createClassificationsModelOptions.trainingParameters() != null) {
            multipartBuilder.addFormDataPart("training_parameters", createClassificationsModelOptions.trainingParameters().toString());
        }
        builder.body((RequestBody)multipartBuilder.build());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ClassificationsModel>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ClassificationsModelList> listClassificationsModels(ListClassificationsModelsOptions listClassificationsModelsOptions) {
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/models/classifications"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"listClassificationsModels");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ClassificationsModelList>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ClassificationsModelList> listClassificationsModels() {
        return this.listClassificationsModels(null);
    }

    public ServiceCall<ClassificationsModel> getClassificationsModel(GetClassificationsModelOptions getClassificationsModelOptions) {
        Validator.notNull((Object)((Object)getClassificationsModelOptions), (String)"getClassificationsModelOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("model_id", getClassificationsModelOptions.modelId());
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/models/classifications/{model_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getClassificationsModel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ClassificationsModel>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ClassificationsModel> updateClassificationsModel(UpdateClassificationsModelOptions updateClassificationsModelOptions) {
        Validator.notNull((Object)((Object)updateClassificationsModelOptions), (String)"updateClassificationsModelOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("model_id", updateClassificationsModelOptions.modelId());
        RequestBuilder builder = RequestBuilder.put((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/models/classifications/{model_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"updateClassificationsModel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
        multipartBuilder.setType(MultipartBody.FORM);
        multipartBuilder.addFormDataPart("language", updateClassificationsModelOptions.language());
        RequestBody trainingDataBody = RequestUtils.inputStreamBody((InputStream)updateClassificationsModelOptions.trainingData(), (String)updateClassificationsModelOptions.trainingDataContentType());
        multipartBuilder.addFormDataPart("training_data", "filename", trainingDataBody);
        if (updateClassificationsModelOptions.name() != null) {
            multipartBuilder.addFormDataPart("name", updateClassificationsModelOptions.name());
        }
        if (updateClassificationsModelOptions.description() != null) {
            multipartBuilder.addFormDataPart("description", updateClassificationsModelOptions.description());
        }
        if (updateClassificationsModelOptions.modelVersion() != null) {
            multipartBuilder.addFormDataPart("model_version", updateClassificationsModelOptions.modelVersion());
        }
        if (updateClassificationsModelOptions.workspaceId() != null) {
            multipartBuilder.addFormDataPart("workspace_id", updateClassificationsModelOptions.workspaceId());
        }
        if (updateClassificationsModelOptions.versionDescription() != null) {
            multipartBuilder.addFormDataPart("version_description", updateClassificationsModelOptions.versionDescription());
        }
        if (updateClassificationsModelOptions.trainingParameters() != null) {
            multipartBuilder.addFormDataPart("training_parameters", updateClassificationsModelOptions.trainingParameters().toString());
        }
        builder.body((RequestBody)multipartBuilder.build());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ClassificationsModel>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DeleteModelResults> deleteClassificationsModel(DeleteClassificationsModelOptions deleteClassificationsModelOptions) {
        Validator.notNull((Object)((Object)deleteClassificationsModelOptions), (String)"deleteClassificationsModelOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("model_id", deleteClassificationsModelOptions.modelId());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/models/classifications/{model_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"deleteClassificationsModel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DeleteModelResults>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }
}

