/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.natural_language_understanding.v1.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.watson.natural_language_understanding.v1.model.CategoriesOptions;
import com.ibm.watson.natural_language_understanding.v1.model.ClassificationsOptions;
import com.ibm.watson.natural_language_understanding.v1.model.ConceptsOptions;
import com.ibm.watson.natural_language_understanding.v1.model.EmotionOptions;
import com.ibm.watson.natural_language_understanding.v1.model.EntitiesOptions;
import com.ibm.watson.natural_language_understanding.v1.model.KeywordsOptions;
import com.ibm.watson.natural_language_understanding.v1.model.RelationsOptions;
import com.ibm.watson.natural_language_understanding.v1.model.SemanticRolesOptions;
import com.ibm.watson.natural_language_understanding.v1.model.SentimentOptions;
import com.ibm.watson.natural_language_understanding.v1.model.SummarizationOptions;
import com.ibm.watson.natural_language_understanding.v1.model.SyntaxOptions;
import java.util.Map;

public class Features
extends GenericModel {
    protected ClassificationsOptions classifications;
    protected ConceptsOptions concepts;
    protected EmotionOptions emotion;
    protected EntitiesOptions entities;
    protected KeywordsOptions keywords;
    protected Map<String, Object> metadata;
    protected RelationsOptions relations;
    @SerializedName(value="semantic_roles")
    protected SemanticRolesOptions semanticRoles;
    protected SentimentOptions sentiment;
    protected SummarizationOptions summarization;
    protected CategoriesOptions categories;
    protected SyntaxOptions syntax;

    protected Features() {
    }

    protected Features(Builder builder) {
        this.classifications = builder.classifications;
        this.concepts = builder.concepts;
        this.emotion = builder.emotion;
        this.entities = builder.entities;
        this.keywords = builder.keywords;
        this.metadata = builder.metadata;
        this.relations = builder.relations;
        this.semanticRoles = builder.semanticRoles;
        this.sentiment = builder.sentiment;
        this.summarization = builder.summarization;
        this.categories = builder.categories;
        this.syntax = builder.syntax;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public ClassificationsOptions classifications() {
        return this.classifications;
    }

    public ConceptsOptions concepts() {
        return this.concepts;
    }

    public EmotionOptions emotion() {
        return this.emotion;
    }

    public EntitiesOptions entities() {
        return this.entities;
    }

    public KeywordsOptions keywords() {
        return this.keywords;
    }

    public Map<String, Object> metadata() {
        return this.metadata;
    }

    public RelationsOptions relations() {
        return this.relations;
    }

    public SemanticRolesOptions semanticRoles() {
        return this.semanticRoles;
    }

    public SentimentOptions sentiment() {
        return this.sentiment;
    }

    public SummarizationOptions summarization() {
        return this.summarization;
    }

    public CategoriesOptions categories() {
        return this.categories;
    }

    public SyntaxOptions syntax() {
        return this.syntax;
    }

    public static class Builder {
        private ClassificationsOptions classifications;
        private ConceptsOptions concepts;
        private EmotionOptions emotion;
        private EntitiesOptions entities;
        private KeywordsOptions keywords;
        private Map<String, Object> metadata;
        private RelationsOptions relations;
        private SemanticRolesOptions semanticRoles;
        private SentimentOptions sentiment;
        private SummarizationOptions summarization;
        private CategoriesOptions categories;
        private SyntaxOptions syntax;

        private Builder(Features features) {
            this.classifications = features.classifications;
            this.concepts = features.concepts;
            this.emotion = features.emotion;
            this.entities = features.entities;
            this.keywords = features.keywords;
            this.metadata = features.metadata;
            this.relations = features.relations;
            this.semanticRoles = features.semanticRoles;
            this.sentiment = features.sentiment;
            this.summarization = features.summarization;
            this.categories = features.categories;
            this.syntax = features.syntax;
        }

        public Builder() {
        }

        public Features build() {
            return new Features(this);
        }

        public Builder classifications(ClassificationsOptions classifications) {
            this.classifications = classifications;
            return this;
        }

        public Builder concepts(ConceptsOptions concepts) {
            this.concepts = concepts;
            return this;
        }

        public Builder emotion(EmotionOptions emotion) {
            this.emotion = emotion;
            return this;
        }

        public Builder entities(EntitiesOptions entities) {
            this.entities = entities;
            return this;
        }

        public Builder keywords(KeywordsOptions keywords) {
            this.keywords = keywords;
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder relations(RelationsOptions relations) {
            this.relations = relations;
            return this;
        }

        public Builder semanticRoles(SemanticRolesOptions semanticRoles) {
            this.semanticRoles = semanticRoles;
            return this;
        }

        public Builder sentiment(SentimentOptions sentiment) {
            this.sentiment = sentiment;
            return this;
        }

        public Builder summarization(SummarizationOptions summarization) {
            this.summarization = summarization;
            return this;
        }

        public Builder categories(CategoriesOptions categories) {
            this.categories = categories;
            return this;
        }

        public Builder syntax(SyntaxOptions syntax) {
            this.syntax = syntax;
            return this;
        }
    }
}

