/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.natural_language_understanding.v1;

import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.http.ResponseConverter;
import com.ibm.cloud.sdk.core.http.ServiceCall;
import com.ibm.cloud.sdk.core.security.AuthenticatorConfig;
import com.ibm.cloud.sdk.core.service.BaseService;
import com.ibm.cloud.sdk.core.util.GsonSingleton;
import com.ibm.cloud.sdk.core.util.ResponseConverterUtils;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.common.SdkCommon;
import com.ibm.watson.natural_language_understanding.v1.model.AnalysisResults;
import com.ibm.watson.natural_language_understanding.v1.model.AnalyzeOptions;
import com.ibm.watson.natural_language_understanding.v1.model.DeleteModelOptions;
import com.ibm.watson.natural_language_understanding.v1.model.DeleteModelResults;
import com.ibm.watson.natural_language_understanding.v1.model.ListModelsOptions;
import com.ibm.watson.natural_language_understanding.v1.model.ListModelsResults;
import java.lang.reflect.Type;
import java.util.Map;
import okhttp3.HttpUrl;

public class NaturalLanguageUnderstanding
extends BaseService {
    private static final String SERVICE_NAME = "natural_language_understanding";
    private static final String URL = "https://gateway.watsonplatform.net/natural-language-understanding/api";
    private String versionDate;

    @Deprecated
    public NaturalLanguageUnderstanding(String versionDate) {
        super(SERVICE_NAME);
        if (this.getEndPoint() == null || this.getEndPoint().isEmpty()) {
            this.setEndPoint(URL);
        }
        Validator.isTrue((versionDate != null && !versionDate.isEmpty() ? 1 : 0) != 0, (String)"version cannot be null.");
        this.versionDate = versionDate;
    }

    @Deprecated
    public NaturalLanguageUnderstanding(String versionDate, String username, String password) {
        this(versionDate);
        this.setUsernameAndPassword(username, password);
    }

    public NaturalLanguageUnderstanding(String versionDate, AuthenticatorConfig authenticatorConfig) {
        super(SERVICE_NAME);
        if (this.getEndPoint() == null || this.getEndPoint().isEmpty()) {
            this.setEndPoint(URL);
        }
        this.setAuthenticator(authenticatorConfig);
        Validator.isTrue((versionDate != null && !versionDate.isEmpty() ? 1 : 0) != 0, (String)"version cannot be null.");
        this.versionDate = versionDate;
    }

    public ServiceCall<AnalysisResults> analyze(AnalyzeOptions analyzeOptions) {
        Validator.notNull((Object)((Object)analyzeOptions), (String)"analyzeOptions cannot be null");
        String[] pathSegments = new String[]{"v1/analyze"};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"natural-language-understanding", (String)"v1", (String)"analyze");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        contentJson.add("features", GsonSingleton.getGson().toJsonTree((Object)analyzeOptions.features()));
        if (analyzeOptions.text() != null) {
            contentJson.addProperty("text", analyzeOptions.text());
        }
        if (analyzeOptions.html() != null) {
            contentJson.addProperty("html", analyzeOptions.html());
        }
        if (analyzeOptions.url() != null) {
            contentJson.addProperty("url", analyzeOptions.url());
        }
        if (analyzeOptions.clean() != null) {
            contentJson.addProperty("clean", analyzeOptions.clean());
        }
        if (analyzeOptions.xpath() != null) {
            contentJson.addProperty("xpath", analyzeOptions.xpath());
        }
        if (analyzeOptions.fallbackToRaw() != null) {
            contentJson.addProperty("fallback_to_raw", analyzeOptions.fallbackToRaw());
        }
        if (analyzeOptions.returnAnalyzedText() != null) {
            contentJson.addProperty("return_analyzed_text", analyzeOptions.returnAnalyzedText());
        }
        if (analyzeOptions.language() != null) {
            contentJson.addProperty("language", analyzeOptions.language());
        }
        if (analyzeOptions.limitTextCharacters() != null) {
            contentJson.addProperty("limit_text_characters", (Number)analyzeOptions.limitTextCharacters());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<AnalysisResults>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ListModelsResults> listModels(ListModelsOptions listModelsOptions) {
        String[] pathSegments = new String[]{"v1/models"};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"natural-language-understanding", (String)"v1", (String)"listModels");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (listModelsOptions != null) {
            // empty if block
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ListModelsResults>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ListModelsResults> listModels() {
        return this.listModels(null);
    }

    public ServiceCall<DeleteModelResults> deleteModel(DeleteModelOptions deleteModelOptions) {
        Validator.notNull((Object)((Object)deleteModelOptions), (String)"deleteModelOptions cannot be null");
        String[] pathSegments = new String[]{"v1/models"};
        String[] pathParameters = new String[]{deleteModelOptions.modelId()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getEndPoint(), (String[])pathSegments, (String[])pathParameters));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)"natural-language-understanding", (String)"v1", (String)"deleteModel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DeleteModelResults>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }
}

