/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.natural_language_understanding.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;

public class EntitiesOptions
extends GenericModel {
    protected Long limit;
    protected Boolean mentions;
    protected String model;
    protected Boolean sentiment;
    protected Boolean emotion;

    protected EntitiesOptions(Builder builder) {
        this.limit = builder.limit;
        this.mentions = builder.mentions;
        this.model = builder.model;
        this.sentiment = builder.sentiment;
        this.emotion = builder.emotion;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public Long limit() {
        return this.limit;
    }

    public Boolean mentions() {
        return this.mentions;
    }

    public String model() {
        return this.model;
    }

    public Boolean sentiment() {
        return this.sentiment;
    }

    public Boolean emotion() {
        return this.emotion;
    }

    public static class Builder {
        private Long limit;
        private Boolean mentions;
        private String model;
        private Boolean sentiment;
        private Boolean emotion;

        private Builder(EntitiesOptions entitiesOptions) {
            this.limit = entitiesOptions.limit;
            this.mentions = entitiesOptions.mentions;
            this.model = entitiesOptions.model;
            this.sentiment = entitiesOptions.sentiment;
            this.emotion = entitiesOptions.emotion;
        }

        public Builder() {
        }

        public EntitiesOptions build() {
            return new EntitiesOptions(this);
        }

        public Builder limit(long limit) {
            this.limit = limit;
            return this;
        }

        public Builder mentions(Boolean mentions) {
            this.mentions = mentions;
            return this;
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder sentiment(Boolean sentiment) {
            this.sentiment = sentiment;
            return this;
        }

        public Builder emotion(Boolean emotion) {
            this.emotion = emotion;
            return this;
        }
    }
}

