/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.natural_language_understanding.v1;

import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.http.ResponseConverter;
import com.ibm.cloud.sdk.core.http.ServiceCall;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.ConfigBasedAuthenticatorFactory;
import com.ibm.cloud.sdk.core.service.BaseService;
import com.ibm.cloud.sdk.core.util.GsonSingleton;
import com.ibm.cloud.sdk.core.util.ResponseConverterUtils;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.common.SdkCommon;
import com.ibm.watson.natural_language_understanding.v1.model.AnalysisResults;
import com.ibm.watson.natural_language_understanding.v1.model.AnalyzeOptions;
import com.ibm.watson.natural_language_understanding.v1.model.DeleteModelOptions;
import com.ibm.watson.natural_language_understanding.v1.model.DeleteModelResults;
import com.ibm.watson.natural_language_understanding.v1.model.ListModelsOptions;
import com.ibm.watson.natural_language_understanding.v1.model.ListModelsResults;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import okhttp3.HttpUrl;

public class NaturalLanguageUnderstanding
extends BaseService {
    public static final String DEFAULT_SERVICE_NAME = "natural-language-understanding";
    public static final String DEFAULT_SERVICE_URL = "https://api.us-south.natural-language-understanding.watson.cloud.ibm.com";
    private String version;

    public NaturalLanguageUnderstanding(String version) {
        this(version, DEFAULT_SERVICE_NAME, ConfigBasedAuthenticatorFactory.getAuthenticator((String)DEFAULT_SERVICE_NAME));
    }

    public NaturalLanguageUnderstanding(String version, Authenticator authenticator) {
        this(version, DEFAULT_SERVICE_NAME, authenticator);
    }

    public NaturalLanguageUnderstanding(String version, String serviceName) {
        this(version, serviceName, ConfigBasedAuthenticatorFactory.getAuthenticator((String)serviceName));
    }

    public NaturalLanguageUnderstanding(String version, String serviceName, Authenticator authenticator) {
        super(serviceName, authenticator);
        this.setServiceUrl(DEFAULT_SERVICE_URL);
        this.setVersion(version);
        this.configureService(serviceName);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        Validator.notEmpty((String)version, (String)"version cannot be empty.");
        this.version = version;
    }

    public ServiceCall<AnalysisResults> analyze(AnalyzeOptions analyzeOptions) {
        Validator.notNull((Object)((Object)analyzeOptions), (String)"analyzeOptions cannot be null");
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/analyze"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"analyze");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        JsonObject contentJson = new JsonObject();
        contentJson.add("features", GsonSingleton.getGson().toJsonTree((Object)analyzeOptions.features()));
        if (analyzeOptions.text() != null) {
            contentJson.addProperty("text", analyzeOptions.text());
        }
        if (analyzeOptions.html() != null) {
            contentJson.addProperty("html", analyzeOptions.html());
        }
        if (analyzeOptions.url() != null) {
            contentJson.addProperty("url", analyzeOptions.url());
        }
        if (analyzeOptions.clean() != null) {
            contentJson.addProperty("clean", analyzeOptions.clean());
        }
        if (analyzeOptions.xpath() != null) {
            contentJson.addProperty("xpath", analyzeOptions.xpath());
        }
        if (analyzeOptions.fallbackToRaw() != null) {
            contentJson.addProperty("fallback_to_raw", analyzeOptions.fallbackToRaw());
        }
        if (analyzeOptions.returnAnalyzedText() != null) {
            contentJson.addProperty("return_analyzed_text", analyzeOptions.returnAnalyzedText());
        }
        if (analyzeOptions.language() != null) {
            contentJson.addProperty("language", analyzeOptions.language());
        }
        if (analyzeOptions.limitTextCharacters() != null) {
            contentJson.addProperty("limit_text_characters", (Number)analyzeOptions.limitTextCharacters());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<AnalysisResults>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ListModelsResults> listModels(ListModelsOptions listModelsOptions) {
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/models"));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"listModels");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<ListModelsResults>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ListModelsResults> listModels() {
        return this.listModels(null);
    }

    public ServiceCall<DeleteModelResults> deleteModel(DeleteModelOptions deleteModelOptions) {
        Validator.notNull((Object)((Object)deleteModelOptions), (String)"deleteModelOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("model_id", deleteModelOptions.modelId());
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.resolveRequestUrl((String)this.getServiceUrl(), (String)"/v1/models/{model_id}", pathParamsMap));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"deleteModel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"version", String.valueOf(this.version)});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<DeleteModelResults>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }
}

