/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.natural_language_understanding.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.natural_language_understanding.v1.model.Features;

public class AnalyzeOptions
extends GenericModel {
    protected Features features;
    protected String text;
    protected String html;
    protected String url;
    protected Boolean clean;
    protected String xpath;
    protected Boolean fallbackToRaw;
    protected Boolean returnAnalyzedText;
    protected String language;
    protected Long limitTextCharacters;

    protected AnalyzeOptions(Builder builder) {
        Validator.notNull((Object)((Object)builder.features), (String)"features cannot be null");
        this.features = builder.features;
        this.text = builder.text;
        this.html = builder.html;
        this.url = builder.url;
        this.clean = builder.clean;
        this.xpath = builder.xpath;
        this.fallbackToRaw = builder.fallbackToRaw;
        this.returnAnalyzedText = builder.returnAnalyzedText;
        this.language = builder.language;
        this.limitTextCharacters = builder.limitTextCharacters;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public Features features() {
        return this.features;
    }

    public String text() {
        return this.text;
    }

    public String html() {
        return this.html;
    }

    public String url() {
        return this.url;
    }

    public Boolean clean() {
        return this.clean;
    }

    public String xpath() {
        return this.xpath;
    }

    public Boolean fallbackToRaw() {
        return this.fallbackToRaw;
    }

    public Boolean returnAnalyzedText() {
        return this.returnAnalyzedText;
    }

    public String language() {
        return this.language;
    }

    public Long limitTextCharacters() {
        return this.limitTextCharacters;
    }

    public static class Builder {
        private Features features;
        private String text;
        private String html;
        private String url;
        private Boolean clean;
        private String xpath;
        private Boolean fallbackToRaw;
        private Boolean returnAnalyzedText;
        private String language;
        private Long limitTextCharacters;

        private Builder(AnalyzeOptions analyzeOptions) {
            this.features = analyzeOptions.features;
            this.text = analyzeOptions.text;
            this.html = analyzeOptions.html;
            this.url = analyzeOptions.url;
            this.clean = analyzeOptions.clean;
            this.xpath = analyzeOptions.xpath;
            this.fallbackToRaw = analyzeOptions.fallbackToRaw;
            this.returnAnalyzedText = analyzeOptions.returnAnalyzedText;
            this.language = analyzeOptions.language;
            this.limitTextCharacters = analyzeOptions.limitTextCharacters;
        }

        public Builder() {
        }

        public Builder(Features features) {
            this.features = features;
        }

        public AnalyzeOptions build() {
            return new AnalyzeOptions(this);
        }

        public Builder features(Features features) {
            this.features = features;
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder html(String html) {
            this.html = html;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder clean(Boolean clean) {
            this.clean = clean;
            return this;
        }

        public Builder xpath(String xpath) {
            this.xpath = xpath;
            return this;
        }

        public Builder fallbackToRaw(Boolean fallbackToRaw) {
            this.fallbackToRaw = fallbackToRaw;
            return this;
        }

        public Builder returnAnalyzedText(Boolean returnAnalyzedText) {
            this.returnAnalyzedText = returnAnalyzedText;
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            return this;
        }

        public Builder limitTextCharacters(long limitTextCharacters) {
            this.limitTextCharacters = limitTextCharacters;
            return this;
        }
    }
}

