/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.personality_insights.v3.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.watson.personality_insights.v3.model.Content;

public class ProfileOptions
extends GenericModel {
    private Content content;
    private String body;
    private String contentType;
    private String contentLanguage;
    private String acceptLanguage;
    private Boolean rawScores;
    private Boolean csvHeaders;
    private Boolean consumptionPreferences;

    private ProfileOptions(Builder builder) {
        this.content = builder.content;
        this.body = builder.body;
        this.contentType = builder.contentType;
        this.contentLanguage = builder.contentLanguage;
        this.acceptLanguage = builder.acceptLanguage;
        this.rawScores = builder.rawScores;
        this.csvHeaders = builder.csvHeaders;
        this.consumptionPreferences = builder.consumptionPreferences;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public Content content() {
        return this.content;
    }

    public String body() {
        return this.body;
    }

    public String contentType() {
        return this.contentType;
    }

    public String contentLanguage() {
        return this.contentLanguage;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public Boolean rawScores() {
        return this.rawScores;
    }

    public Boolean csvHeaders() {
        return this.csvHeaders;
    }

    public Boolean consumptionPreferences() {
        return this.consumptionPreferences;
    }

    public static class Builder {
        private Content content;
        private String body;
        private String contentType;
        private String contentLanguage;
        private String acceptLanguage;
        private Boolean rawScores;
        private Boolean csvHeaders;
        private Boolean consumptionPreferences;

        private Builder(ProfileOptions profileOptions) {
            this.content = profileOptions.content;
            this.body = profileOptions.body;
            this.contentType = profileOptions.contentType;
            this.contentLanguage = profileOptions.contentLanguage;
            this.acceptLanguage = profileOptions.acceptLanguage;
            this.rawScores = profileOptions.rawScores;
            this.csvHeaders = profileOptions.csvHeaders;
            this.consumptionPreferences = profileOptions.consumptionPreferences;
        }

        public Builder() {
        }

        public ProfileOptions build() {
            return new ProfileOptions(this);
        }

        public Builder contentLanguage(String contentLanguage) {
            this.contentLanguage = contentLanguage;
            return this;
        }

        public Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public Builder rawScores(Boolean rawScores) {
            this.rawScores = rawScores;
            return this;
        }

        public Builder csvHeaders(Boolean csvHeaders) {
            this.csvHeaders = csvHeaders;
            return this;
        }

        public Builder consumptionPreferences(Boolean consumptionPreferences) {
            this.consumptionPreferences = consumptionPreferences;
            return this;
        }

        public Builder content(Content content) {
            this.content = content;
            this.contentType = "application/json";
            return this;
        }

        public Builder html(String html) {
            this.body = html;
            this.contentType = "text/html";
            return this;
        }

        public Builder text(String text) {
            this.body = text;
            this.contentType = "text/plain";
            return this;
        }
    }

    public static interface AcceptLanguage {
        public static final String AR = "ar";
        public static final String DE = "de";
        public static final String EN = "en";
        public static final String ES = "es";
        public static final String FR = "fr";
        public static final String IT = "it";
        public static final String JA = "ja";
        public static final String KO = "ko";
        public static final String PT_BR = "pt-br";
        public static final String ZH_CN = "zh-cn";
        public static final String ZH_TW = "zh-tw";
    }

    public static interface ContentLanguage {
        public static final String AR = "ar";
        public static final String EN = "en";
        public static final String ES = "es";
        public static final String JA = "ja";
        public static final String KO = "ko";
    }
}

