/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.personality_insights.v3;

import com.google.gson.reflect.TypeToken;
import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.http.ResponseConverter;
import com.ibm.cloud.sdk.core.http.ServiceCall;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.ConfigBasedAuthenticatorFactory;
import com.ibm.cloud.sdk.core.service.BaseService;
import com.ibm.cloud.sdk.core.util.ResponseConverterUtils;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.common.SdkCommon;
import com.ibm.watson.personality_insights.v3.model.Profile;
import com.ibm.watson.personality_insights.v3.model.ProfileOptions;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Map;
import okhttp3.HttpUrl;

public class PersonalityInsights
extends BaseService {
    private static final String DEFAULT_SERVICE_NAME = "personality_insights";
    private static final String DEFAULT_SERVICE_URL = "https://gateway.watsonplatform.net/personality-insights/api";
    private String versionDate;

    public PersonalityInsights(String versionDate) {
        this(versionDate, DEFAULT_SERVICE_NAME, ConfigBasedAuthenticatorFactory.getAuthenticator((String)DEFAULT_SERVICE_NAME));
    }

    public PersonalityInsights(String versionDate, Authenticator authenticator) {
        this(versionDate, DEFAULT_SERVICE_NAME, authenticator);
    }

    public PersonalityInsights(String versionDate, String serviceName) {
        this(versionDate, serviceName, ConfigBasedAuthenticatorFactory.getAuthenticator((String)serviceName));
    }

    public PersonalityInsights(String versionDate, String serviceName, Authenticator authenticator) {
        super(serviceName, authenticator);
        this.setServiceUrl(DEFAULT_SERVICE_URL);
        Validator.isTrue((versionDate != null && !versionDate.isEmpty() ? 1 : 0) != 0, (String)"version cannot be null.");
        this.versionDate = versionDate;
        this.configureService(serviceName);
    }

    public ServiceCall<Profile> profile(ProfileOptions profileOptions) {
        Validator.notNull((Object)((Object)profileOptions), (String)"profileOptions cannot be null");
        String[] pathSegments = new String[]{"v3/profile"};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v3", (String)"profile");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (profileOptions.contentType() != null) {
            builder.header(new Object[]{"Content-Type", profileOptions.contentType()});
        }
        if (profileOptions.contentLanguage() != null) {
            builder.header(new Object[]{"Content-Language", profileOptions.contentLanguage()});
        }
        if (profileOptions.acceptLanguage() != null) {
            builder.header(new Object[]{"Accept-Language", profileOptions.acceptLanguage()});
        }
        if (profileOptions.rawScores() != null) {
            builder.query(new Object[]{"raw_scores", String.valueOf(profileOptions.rawScores())});
        }
        if (profileOptions.csvHeaders() != null) {
            builder.query(new Object[]{"csv_headers", String.valueOf(profileOptions.csvHeaders())});
        }
        if (profileOptions.consumptionPreferences() != null) {
            builder.query(new Object[]{"consumption_preferences", String.valueOf(profileOptions.consumptionPreferences())});
        }
        builder.bodyContent(profileOptions.contentType(), (Object)profileOptions.content(), null, profileOptions.body());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Profile>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InputStream> profileAsCsv(ProfileOptions profileOptions) {
        Validator.notNull((Object)((Object)profileOptions), (String)"profileOptions cannot be null");
        String[] pathSegments = new String[]{"v3/profile"};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        builder.query(new Object[]{"version", this.versionDate});
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v3", (String)"profileAsCsv");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "text/csv"});
        if (profileOptions.contentType() != null) {
            builder.header(new Object[]{"Content-Type", profileOptions.contentType()});
        }
        if (profileOptions.contentLanguage() != null) {
            builder.header(new Object[]{"Content-Language", profileOptions.contentLanguage()});
        }
        if (profileOptions.acceptLanguage() != null) {
            builder.header(new Object[]{"Accept-Language", profileOptions.acceptLanguage()});
        }
        if (profileOptions.rawScores() != null) {
            builder.query(new Object[]{"raw_scores", String.valueOf(profileOptions.rawScores())});
        }
        if (profileOptions.csvHeaders() != null) {
            builder.query(new Object[]{"csv_headers", String.valueOf(profileOptions.csvHeaders())});
        }
        if (profileOptions.consumptionPreferences() != null) {
            builder.query(new Object[]{"consumption_preferences", String.valueOf(profileOptions.consumptionPreferences())});
        }
        builder.bodyContent(profileOptions.contentType(), (Object)profileOptions.content(), null, profileOptions.body());
        ResponseConverter responseConverter = ResponseConverterUtils.getInputStream();
        return this.createServiceCall(builder.build(), responseConverter);
    }
}

