/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.speech_to_text.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class CreateJobOptions
extends GenericModel {
    protected InputStream audio;
    protected String contentType;
    protected String model;
    protected String callbackUrl;
    protected String events;
    protected String userToken;
    protected Long resultsTtl;
    protected String languageCustomizationId;
    protected String acousticCustomizationId;
    protected String baseModelVersion;
    protected Double customizationWeight;
    protected Long inactivityTimeout;
    protected List<String> keywords;
    protected Float keywordsThreshold;
    protected Long maxAlternatives;
    protected Float wordAlternativesThreshold;
    protected Boolean wordConfidence;
    protected Boolean timestamps;
    protected Boolean profanityFilter;
    protected Boolean smartFormatting;
    protected Long smartFormattingVersion;
    protected Boolean speakerLabels;
    protected String grammarName;
    protected Boolean redaction;
    protected Boolean processingMetrics;
    protected Float processingMetricsInterval;
    protected Boolean audioMetrics;
    protected Double endOfPhraseSilenceTime;
    protected Boolean splitTranscriptAtPhraseEnd;
    protected Float speechDetectorSensitivity;
    protected Float backgroundAudioSuppression;
    protected Boolean lowLatency;
    protected Float characterInsertionBias;

    protected CreateJobOptions() {
    }

    protected CreateJobOptions(Builder builder) {
        Validator.notNull((Object)builder.audio, (String)"audio cannot be null");
        this.audio = builder.audio;
        this.contentType = builder.contentType;
        this.model = builder.model;
        this.callbackUrl = builder.callbackUrl;
        this.events = builder.events;
        this.userToken = builder.userToken;
        this.resultsTtl = builder.resultsTtl;
        this.languageCustomizationId = builder.languageCustomizationId;
        this.acousticCustomizationId = builder.acousticCustomizationId;
        this.baseModelVersion = builder.baseModelVersion;
        this.customizationWeight = builder.customizationWeight;
        this.inactivityTimeout = builder.inactivityTimeout;
        this.keywords = builder.keywords;
        this.keywordsThreshold = builder.keywordsThreshold;
        this.maxAlternatives = builder.maxAlternatives;
        this.wordAlternativesThreshold = builder.wordAlternativesThreshold;
        this.wordConfidence = builder.wordConfidence;
        this.timestamps = builder.timestamps;
        this.profanityFilter = builder.profanityFilter;
        this.smartFormatting = builder.smartFormatting;
        this.smartFormattingVersion = builder.smartFormattingVersion;
        this.speakerLabels = builder.speakerLabels;
        this.grammarName = builder.grammarName;
        this.redaction = builder.redaction;
        this.processingMetrics = builder.processingMetrics;
        this.processingMetricsInterval = builder.processingMetricsInterval;
        this.audioMetrics = builder.audioMetrics;
        this.endOfPhraseSilenceTime = builder.endOfPhraseSilenceTime;
        this.splitTranscriptAtPhraseEnd = builder.splitTranscriptAtPhraseEnd;
        this.speechDetectorSensitivity = builder.speechDetectorSensitivity;
        this.backgroundAudioSuppression = builder.backgroundAudioSuppression;
        this.lowLatency = builder.lowLatency;
        this.characterInsertionBias = builder.characterInsertionBias;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public InputStream audio() {
        return this.audio;
    }

    public String contentType() {
        return this.contentType;
    }

    public String model() {
        return this.model;
    }

    public String callbackUrl() {
        return this.callbackUrl;
    }

    public String events() {
        return this.events;
    }

    public String userToken() {
        return this.userToken;
    }

    public Long resultsTtl() {
        return this.resultsTtl;
    }

    public String languageCustomizationId() {
        return this.languageCustomizationId;
    }

    public String acousticCustomizationId() {
        return this.acousticCustomizationId;
    }

    public String baseModelVersion() {
        return this.baseModelVersion;
    }

    public Double customizationWeight() {
        return this.customizationWeight;
    }

    public Long inactivityTimeout() {
        return this.inactivityTimeout;
    }

    public List<String> keywords() {
        return this.keywords;
    }

    public Float keywordsThreshold() {
        return this.keywordsThreshold;
    }

    public Long maxAlternatives() {
        return this.maxAlternatives;
    }

    public Float wordAlternativesThreshold() {
        return this.wordAlternativesThreshold;
    }

    public Boolean wordConfidence() {
        return this.wordConfidence;
    }

    public Boolean timestamps() {
        return this.timestamps;
    }

    public Boolean profanityFilter() {
        return this.profanityFilter;
    }

    public Boolean smartFormatting() {
        return this.smartFormatting;
    }

    public Long smartFormattingVersion() {
        return this.smartFormattingVersion;
    }

    public Boolean speakerLabels() {
        return this.speakerLabels;
    }

    public String grammarName() {
        return this.grammarName;
    }

    public Boolean redaction() {
        return this.redaction;
    }

    public Boolean processingMetrics() {
        return this.processingMetrics;
    }

    public Float processingMetricsInterval() {
        return this.processingMetricsInterval;
    }

    public Boolean audioMetrics() {
        return this.audioMetrics;
    }

    public Double endOfPhraseSilenceTime() {
        return this.endOfPhraseSilenceTime;
    }

    public Boolean splitTranscriptAtPhraseEnd() {
        return this.splitTranscriptAtPhraseEnd;
    }

    public Float speechDetectorSensitivity() {
        return this.speechDetectorSensitivity;
    }

    public Float backgroundAudioSuppression() {
        return this.backgroundAudioSuppression;
    }

    public Boolean lowLatency() {
        return this.lowLatency;
    }

    public Float characterInsertionBias() {
        return this.characterInsertionBias;
    }

    public static class Builder {
        private InputStream audio;
        private String contentType;
        private String model;
        private String callbackUrl;
        private String events;
        private String userToken;
        private Long resultsTtl;
        private String languageCustomizationId;
        private String acousticCustomizationId;
        private String baseModelVersion;
        private Double customizationWeight;
        private Long inactivityTimeout;
        private List<String> keywords;
        private Float keywordsThreshold;
        private Long maxAlternatives;
        private Float wordAlternativesThreshold;
        private Boolean wordConfidence;
        private Boolean timestamps;
        private Boolean profanityFilter;
        private Boolean smartFormatting;
        private Long smartFormattingVersion;
        private Boolean speakerLabels;
        private String grammarName;
        private Boolean redaction;
        private Boolean processingMetrics;
        private Float processingMetricsInterval;
        private Boolean audioMetrics;
        private Double endOfPhraseSilenceTime;
        private Boolean splitTranscriptAtPhraseEnd;
        private Float speechDetectorSensitivity;
        private Float backgroundAudioSuppression;
        private Boolean lowLatency;
        private Float characterInsertionBias;

        private Builder(CreateJobOptions createJobOptions) {
            this.audio = createJobOptions.audio;
            this.contentType = createJobOptions.contentType;
            this.model = createJobOptions.model;
            this.callbackUrl = createJobOptions.callbackUrl;
            this.events = createJobOptions.events;
            this.userToken = createJobOptions.userToken;
            this.resultsTtl = createJobOptions.resultsTtl;
            this.languageCustomizationId = createJobOptions.languageCustomizationId;
            this.acousticCustomizationId = createJobOptions.acousticCustomizationId;
            this.baseModelVersion = createJobOptions.baseModelVersion;
            this.customizationWeight = createJobOptions.customizationWeight;
            this.inactivityTimeout = createJobOptions.inactivityTimeout;
            this.keywords = createJobOptions.keywords;
            this.keywordsThreshold = createJobOptions.keywordsThreshold;
            this.maxAlternatives = createJobOptions.maxAlternatives;
            this.wordAlternativesThreshold = createJobOptions.wordAlternativesThreshold;
            this.wordConfidence = createJobOptions.wordConfidence;
            this.timestamps = createJobOptions.timestamps;
            this.profanityFilter = createJobOptions.profanityFilter;
            this.smartFormatting = createJobOptions.smartFormatting;
            this.smartFormattingVersion = createJobOptions.smartFormattingVersion;
            this.speakerLabels = createJobOptions.speakerLabels;
            this.grammarName = createJobOptions.grammarName;
            this.redaction = createJobOptions.redaction;
            this.processingMetrics = createJobOptions.processingMetrics;
            this.processingMetricsInterval = createJobOptions.processingMetricsInterval;
            this.audioMetrics = createJobOptions.audioMetrics;
            this.endOfPhraseSilenceTime = createJobOptions.endOfPhraseSilenceTime;
            this.splitTranscriptAtPhraseEnd = createJobOptions.splitTranscriptAtPhraseEnd;
            this.speechDetectorSensitivity = createJobOptions.speechDetectorSensitivity;
            this.backgroundAudioSuppression = createJobOptions.backgroundAudioSuppression;
            this.lowLatency = createJobOptions.lowLatency;
            this.characterInsertionBias = createJobOptions.characterInsertionBias;
        }

        public Builder() {
        }

        public Builder(InputStream audio) {
            this.audio = audio;
        }

        public CreateJobOptions build() {
            return new CreateJobOptions(this);
        }

        public Builder addKeyword(String keyword) {
            Validator.notNull((Object)keyword, (String)"keyword cannot be null");
            if (this.keywords == null) {
                this.keywords = new ArrayList<String>();
            }
            this.keywords.add(keyword);
            return this;
        }

        public Builder audio(InputStream audio) {
            this.audio = audio;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder callbackUrl(String callbackUrl) {
            this.callbackUrl = callbackUrl;
            return this;
        }

        public Builder events(String events) {
            this.events = events;
            return this;
        }

        public Builder userToken(String userToken) {
            this.userToken = userToken;
            return this;
        }

        public Builder resultsTtl(long resultsTtl) {
            this.resultsTtl = resultsTtl;
            return this;
        }

        public Builder languageCustomizationId(String languageCustomizationId) {
            this.languageCustomizationId = languageCustomizationId;
            return this;
        }

        public Builder acousticCustomizationId(String acousticCustomizationId) {
            this.acousticCustomizationId = acousticCustomizationId;
            return this;
        }

        public Builder baseModelVersion(String baseModelVersion) {
            this.baseModelVersion = baseModelVersion;
            return this;
        }

        public Builder customizationWeight(Double customizationWeight) {
            this.customizationWeight = customizationWeight;
            return this;
        }

        public Builder inactivityTimeout(long inactivityTimeout) {
            this.inactivityTimeout = inactivityTimeout;
            return this;
        }

        public Builder keywords(List<String> keywords) {
            this.keywords = keywords;
            return this;
        }

        public Builder keywordsThreshold(Float keywordsThreshold) {
            this.keywordsThreshold = keywordsThreshold;
            return this;
        }

        public Builder maxAlternatives(long maxAlternatives) {
            this.maxAlternatives = maxAlternatives;
            return this;
        }

        public Builder wordAlternativesThreshold(Float wordAlternativesThreshold) {
            this.wordAlternativesThreshold = wordAlternativesThreshold;
            return this;
        }

        public Builder wordConfidence(Boolean wordConfidence) {
            this.wordConfidence = wordConfidence;
            return this;
        }

        public Builder timestamps(Boolean timestamps) {
            this.timestamps = timestamps;
            return this;
        }

        public Builder profanityFilter(Boolean profanityFilter) {
            this.profanityFilter = profanityFilter;
            return this;
        }

        public Builder smartFormatting(Boolean smartFormatting) {
            this.smartFormatting = smartFormatting;
            return this;
        }

        public Builder smartFormattingVersion(long smartFormattingVersion) {
            this.smartFormattingVersion = smartFormattingVersion;
            return this;
        }

        public Builder speakerLabels(Boolean speakerLabels) {
            this.speakerLabels = speakerLabels;
            return this;
        }

        public Builder grammarName(String grammarName) {
            this.grammarName = grammarName;
            return this;
        }

        public Builder redaction(Boolean redaction) {
            this.redaction = redaction;
            return this;
        }

        public Builder processingMetrics(Boolean processingMetrics) {
            this.processingMetrics = processingMetrics;
            return this;
        }

        public Builder processingMetricsInterval(Float processingMetricsInterval) {
            this.processingMetricsInterval = processingMetricsInterval;
            return this;
        }

        public Builder audioMetrics(Boolean audioMetrics) {
            this.audioMetrics = audioMetrics;
            return this;
        }

        public Builder endOfPhraseSilenceTime(Double endOfPhraseSilenceTime) {
            this.endOfPhraseSilenceTime = endOfPhraseSilenceTime;
            return this;
        }

        public Builder splitTranscriptAtPhraseEnd(Boolean splitTranscriptAtPhraseEnd) {
            this.splitTranscriptAtPhraseEnd = splitTranscriptAtPhraseEnd;
            return this;
        }

        public Builder speechDetectorSensitivity(Float speechDetectorSensitivity) {
            this.speechDetectorSensitivity = speechDetectorSensitivity;
            return this;
        }

        public Builder backgroundAudioSuppression(Float backgroundAudioSuppression) {
            this.backgroundAudioSuppression = backgroundAudioSuppression;
            return this;
        }

        public Builder lowLatency(Boolean lowLatency) {
            this.lowLatency = lowLatency;
            return this;
        }

        public Builder characterInsertionBias(Float characterInsertionBias) {
            this.characterInsertionBias = characterInsertionBias;
            return this;
        }

        public Builder audio(File audio) throws FileNotFoundException {
            this.audio = new FileInputStream(audio);
            return this;
        }
    }

    public static interface Events {
        public static final String RECOGNITIONS_STARTED = "recognitions.started";
        public static final String RECOGNITIONS_COMPLETED = "recognitions.completed";
        public static final String RECOGNITIONS_COMPLETED_WITH_RESULTS = "recognitions.completed_with_results";
        public static final String RECOGNITIONS_FAILED = "recognitions.failed";
    }

    public static interface Model {
        public static final String AR_MS_BROADBANDMODEL = "ar-MS_BroadbandModel";
        public static final String AR_MS_TELEPHONY = "ar-MS_Telephony";
        public static final String CS_CZ_TELEPHONY = "cs-CZ_Telephony";
        public static final String DE_DE_BROADBANDMODEL = "de-DE_BroadbandModel";
        public static final String DE_DE_MULTIMEDIA = "de-DE_Multimedia";
        public static final String DE_DE_NARROWBANDMODEL = "de-DE_NarrowbandModel";
        public static final String DE_DE_TELEPHONY = "de-DE_Telephony";
        public static final String EN_AU_BROADBANDMODEL = "en-AU_BroadbandModel";
        public static final String EN_AU_MULTIMEDIA = "en-AU_Multimedia";
        public static final String EN_AU_NARROWBANDMODEL = "en-AU_NarrowbandModel";
        public static final String EN_AU_TELEPHONY = "en-AU_Telephony";
        public static final String EN_IN_TELEPHONY = "en-IN_Telephony";
        public static final String EN_GB_BROADBANDMODEL = "en-GB_BroadbandModel";
        public static final String EN_GB_MULTIMEDIA = "en-GB_Multimedia";
        public static final String EN_GB_NARROWBANDMODEL = "en-GB_NarrowbandModel";
        public static final String EN_GB_TELEPHONY = "en-GB_Telephony";
        public static final String EN_US_BROADBANDMODEL = "en-US_BroadbandModel";
        public static final String EN_US_MULTIMEDIA = "en-US_Multimedia";
        public static final String EN_US_NARROWBANDMODEL = "en-US_NarrowbandModel";
        public static final String EN_US_SHORTFORM_NARROWBANDMODEL = "en-US_ShortForm_NarrowbandModel";
        public static final String EN_US_TELEPHONY = "en-US_Telephony";
        public static final String EN_WW_MEDICAL_TELEPHONY = "en-WW_Medical_Telephony";
        public static final String ES_AR_BROADBANDMODEL = "es-AR_BroadbandModel";
        public static final String ES_AR_NARROWBANDMODEL = "es-AR_NarrowbandModel";
        public static final String ES_CL_BROADBANDMODEL = "es-CL_BroadbandModel";
        public static final String ES_CL_NARROWBANDMODEL = "es-CL_NarrowbandModel";
        public static final String ES_CO_BROADBANDMODEL = "es-CO_BroadbandModel";
        public static final String ES_CO_NARROWBANDMODEL = "es-CO_NarrowbandModel";
        public static final String ES_ES_BROADBANDMODEL = "es-ES_BroadbandModel";
        public static final String ES_ES_NARROWBANDMODEL = "es-ES_NarrowbandModel";
        public static final String ES_ES_MULTIMEDIA = "es-ES_Multimedia";
        public static final String ES_ES_TELEPHONY = "es-ES_Telephony";
        public static final String ES_LA_TELEPHONY = "es-LA_Telephony";
        public static final String ES_MX_BROADBANDMODEL = "es-MX_BroadbandModel";
        public static final String ES_MX_NARROWBANDMODEL = "es-MX_NarrowbandModel";
        public static final String ES_PE_BROADBANDMODEL = "es-PE_BroadbandModel";
        public static final String ES_PE_NARROWBANDMODEL = "es-PE_NarrowbandModel";
        public static final String FR_CA_BROADBANDMODEL = "fr-CA_BroadbandModel";
        public static final String FR_CA_MULTIMEDIA = "fr-CA_Multimedia";
        public static final String FR_CA_NARROWBANDMODEL = "fr-CA_NarrowbandModel";
        public static final String FR_CA_TELEPHONY = "fr-CA_Telephony";
        public static final String FR_FR_BROADBANDMODEL = "fr-FR_BroadbandModel";
        public static final String FR_FR_MULTIMEDIA = "fr-FR_Multimedia";
        public static final String FR_FR_NARROWBANDMODEL = "fr-FR_NarrowbandModel";
        public static final String FR_FR_TELEPHONY = "fr-FR_Telephony";
        public static final String HI_IN_TELEPHONY = "hi-IN_Telephony";
        public static final String IT_IT_BROADBANDMODEL = "it-IT_BroadbandModel";
        public static final String IT_IT_NARROWBANDMODEL = "it-IT_NarrowbandModel";
        public static final String IT_IT_MULTIMEDIA = "it-IT_Multimedia";
        public static final String IT_IT_TELEPHONY = "it-IT_Telephony";
        public static final String JA_JP_BROADBANDMODEL = "ja-JP_BroadbandModel";
        public static final String JA_JP_MULTIMEDIA = "ja-JP_Multimedia";
        public static final String JA_JP_NARROWBANDMODEL = "ja-JP_NarrowbandModel";
        public static final String JA_JP_TELEPHONY = "ja-JP_Telephony";
        public static final String KO_KR_BROADBANDMODEL = "ko-KR_BroadbandModel";
        public static final String KO_KR_MULTIMEDIA = "ko-KR_Multimedia";
        public static final String KO_KR_NARROWBANDMODEL = "ko-KR_NarrowbandModel";
        public static final String KO_KR_TELEPHONY = "ko-KR_Telephony";
        public static final String NL_BE_TELEPHONY = "nl-BE_Telephony";
        public static final String NL_NL_BROADBANDMODEL = "nl-NL_BroadbandModel";
        public static final String NL_NL_MULTIMEDIA = "nl-NL_Multimedia";
        public static final String NL_NL_NARROWBANDMODEL = "nl-NL_NarrowbandModel";
        public static final String NL_NL_TELEPHONY = "nl-NL_Telephony";
        public static final String PT_BR_BROADBANDMODEL = "pt-BR_BroadbandModel";
        public static final String PT_BR_MULTIMEDIA = "pt-BR_Multimedia";
        public static final String PT_BR_NARROWBANDMODEL = "pt-BR_NarrowbandModel";
        public static final String PT_BR_TELEPHONY = "pt-BR_Telephony";
        public static final String SV_SE_TELEPHONY = "sv-SE_Telephony";
        public static final String ZH_CN_BROADBANDMODEL = "zh-CN_BroadbandModel";
        public static final String ZH_CN_NARROWBANDMODEL = "zh-CN_NarrowbandModel";
        public static final String ZH_CN_TELEPHONY = "zh-CN_Telephony";
    }
}

