/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.speech_to_text.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class TrainAcousticModelOptions
extends GenericModel {
    protected String customizationId;
    protected String customLanguageModelId;
    protected Boolean strict;

    protected TrainAcousticModelOptions() {
    }

    protected TrainAcousticModelOptions(Builder builder) {
        Validator.notEmpty((String)builder.customizationId, (String)"customizationId cannot be empty");
        this.customizationId = builder.customizationId;
        this.customLanguageModelId = builder.customLanguageModelId;
        this.strict = builder.strict;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String customizationId() {
        return this.customizationId;
    }

    public String customLanguageModelId() {
        return this.customLanguageModelId;
    }

    public Boolean strict() {
        return this.strict;
    }

    public static class Builder {
        private String customizationId;
        private String customLanguageModelId;
        private Boolean strict;

        private Builder(TrainAcousticModelOptions trainAcousticModelOptions) {
            this.customizationId = trainAcousticModelOptions.customizationId;
            this.customLanguageModelId = trainAcousticModelOptions.customLanguageModelId;
            this.strict = trainAcousticModelOptions.strict;
        }

        public Builder() {
        }

        public Builder(String customizationId) {
            this.customizationId = customizationId;
        }

        public TrainAcousticModelOptions build() {
            return new TrainAcousticModelOptions(this);
        }

        public Builder customizationId(String customizationId) {
            this.customizationId = customizationId;
            return this;
        }

        public Builder customLanguageModelId(String customLanguageModelId) {
            this.customLanguageModelId = customLanguageModelId;
            return this;
        }

        public Builder strict(Boolean strict) {
            this.strict = strict;
            return this;
        }
    }
}

