/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.speech_to_text.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class CreateLanguageModelOptions
extends GenericModel {
    protected String name;
    protected String baseModelName;
    protected String dialect;
    protected String description;

    protected CreateLanguageModelOptions() {
    }

    protected CreateLanguageModelOptions(Builder builder) {
        Validator.notNull((Object)builder.name, (String)"name cannot be null");
        Validator.notNull((Object)builder.baseModelName, (String)"baseModelName cannot be null");
        this.name = builder.name;
        this.baseModelName = builder.baseModelName;
        this.dialect = builder.dialect;
        this.description = builder.description;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String name() {
        return this.name;
    }

    public String baseModelName() {
        return this.baseModelName;
    }

    public String dialect() {
        return this.dialect;
    }

    public String description() {
        return this.description;
    }

    public static class Builder {
        private String name;
        private String baseModelName;
        private String dialect;
        private String description;

        private Builder(CreateLanguageModelOptions createLanguageModelOptions) {
            this.name = createLanguageModelOptions.name;
            this.baseModelName = createLanguageModelOptions.baseModelName;
            this.dialect = createLanguageModelOptions.dialect;
            this.description = createLanguageModelOptions.description;
        }

        public Builder() {
        }

        public Builder(String name, String baseModelName) {
            this.name = name;
            this.baseModelName = baseModelName;
        }

        public CreateLanguageModelOptions build() {
            return new CreateLanguageModelOptions(this);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder baseModelName(String baseModelName) {
            this.baseModelName = baseModelName;
            return this;
        }

        public Builder dialect(String dialect) {
            this.dialect = dialect;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }
    }

    public static interface BaseModelName {
        public static final String AR_MS_TELEPHONY = "ar-MS_Telephony";
        public static final String CS_CZ_TELEPHONY = "cs-CZ_Telephony";
        public static final String DE_DE_BROADBANDMODEL = "de-DE_BroadbandModel";
        public static final String DE_DE_MULTIMEDIA = "de-DE_Multimedia";
        public static final String DE_DE_NARROWBANDMODEL = "de-DE_NarrowbandModel";
        public static final String DE_DE_TELEPHONY = "de-DE_Telephony";
        public static final String EN_AU = "en-AU";
        public static final String EN_AU_BROADBANDMODEL = "en-AU_BroadbandModel";
        public static final String EN_AU_MULTIMEDIA = "en-AU_Multimedia";
        public static final String EN_AU_NARROWBANDMODEL = "en-AU_NarrowbandModel";
        public static final String EN_AU_TELEPHONY = "en-AU_Telephony";
        public static final String EN_GB = "en-GB";
        public static final String EN_GB_BROADBANDMODEL = "en-GB_BroadbandModel";
        public static final String EN_GB_MULTIMEDIA = "en-GB_Multimedia";
        public static final String EN_GB_NARROWBANDMODEL = "en-GB_NarrowbandModel";
        public static final String EN_GB_TELEPHONY = "en-GB_Telephony";
        public static final String EN_IN = "en-IN";
        public static final String EN_IN_TELEPHONY = "en-IN_Telephony";
        public static final String EN_US = "en-US";
        public static final String EN_US_BROADBANDMODEL = "en-US_BroadbandModel";
        public static final String EN_US_MULTIMEDIA = "en-US_Multimedia";
        public static final String EN_US_NARROWBANDMODEL = "en-US_NarrowbandModel";
        public static final String EN_US_SHORTFORM_NARROWBANDMODEL = "en-US_ShortForm_NarrowbandModel";
        public static final String EN_US_TELEPHONY = "en-US_Telephony";
        public static final String EN_WW_MEDICAL_TELEPHONY = "en-WW_Medical_Telephony";
        public static final String ES_AR = "es-AR";
        public static final String ES_AR_BROADBANDMODEL = "es-AR_BroadbandModel";
        public static final String ES_AR_NARROWBANDMODEL = "es-AR_NarrowbandModel";
        public static final String ES_CL = "es-CL";
        public static final String ES_CL_BROADBANDMODEL = "es-CL_BroadbandModel";
        public static final String ES_CL_NARROWBANDMODEL = "es-CL_NarrowbandModel";
        public static final String ES_CO = "es-CO";
        public static final String ES_CO_BROADBANDMODEL = "es-CO_BroadbandModel";
        public static final String ES_CO_NARROWBANDMODEL = "es-CO_NarrowbandModel";
        public static final String ES_ES = "es-ES";
        public static final String ES_ES_BROADBANDMODEL = "es-ES_BroadbandModel";
        public static final String ES_ES_NARROWBANDMODEL = "es-ES_NarrowbandModel";
        public static final String ES_ES_MULTIMEDIA = "es-ES_Multimedia";
        public static final String ES_ES_TELEPHONY = "es-ES_Telephony";
        public static final String ES_LA_TELEPHONY = "es-LA_Telephony";
        public static final String ES_MX = "es-MX";
        public static final String ES_MX_BROADBANDMODEL = "es-MX_BroadbandModel";
        public static final String ES_MX_NARROWBANDMODEL = "es-MX_NarrowbandModel";
        public static final String ES_PE = "es-PE";
        public static final String ES_PE_BROADBANDMODEL = "es-PE_BroadbandModel";
        public static final String ES_PE_NARROWBANDMODEL = "es-PE_NarrowbandModel";
        public static final String FR_CA = "fr-CA";
        public static final String FR_CA_BROADBANDMODEL = "fr-CA_BroadbandModel";
        public static final String FR_CA_MULTIMEDIA = "fr-CA_Multimedia";
        public static final String FR_CA_NARROWBANDMODEL = "fr-CA_NarrowbandModel";
        public static final String FR_CA_TELEPHONY = "fr-CA_Telephony";
        public static final String FR_FR = "fr-FR";
        public static final String FR_FR_BROADBANDMODEL = "fr-FR_BroadbandModel";
        public static final String FR_FR_MULTIMEDIA = "fr-FR_Multimedia";
        public static final String FR_FR_NARROWBANDMODEL = "fr-FR_NarrowbandModel";
        public static final String FR_FR_TELEPHONY = "fr-FR_Telephony";
        public static final String HI_IN_TELEPHONY = "hi-IN_Telephony";
        public static final String IT_IT_BROADBANDMODEL = "it-IT_BroadbandModel";
        public static final String IT_IT_NARROWBANDMODEL = "it-IT_NarrowbandModel";
        public static final String IT_IT_MULTIMEDIA = "it-IT_Multimedia";
        public static final String IT_IT_TELEPHONY = "it-IT_Telephony";
        public static final String JA_JP = "ja-JP";
        public static final String JA_JP_BROADBANDMODEL = "ja-JP_BroadbandModel";
        public static final String JA_JP_MULTIMEDIA = "ja-JP_Multimedia";
        public static final String JA_JP_NARROWBANDMODEL = "ja-JP_NarrowbandModel";
        public static final String JA_JP_TELEPHONY = "ja-JP_Telephony";
        public static final String KO_KR_BROADBANDMODEL = "ko-KR_BroadbandModel";
        public static final String KO_KR_MULTIMEDIA = "ko-KR_Multimedia";
        public static final String KO_KR_NARROWBANDMODEL = "ko-KR_NarrowbandModel";
        public static final String KO_KR_TELEPHONY = "ko-KR_Telephony";
        public static final String NL_BE_TELEPHONY = "nl-BE_Telephony";
        public static final String NL_NL_BROADBANDMODEL = "nl-NL_BroadbandModel";
        public static final String NL_NL_MULTIMEDIA = "nl-NL_Multimedia";
        public static final String NL_NL_NARROWBANDMODEL = "nl-NL_NarrowbandModel";
        public static final String NL_NL_TELEPHONY = "nl-NL_Telephony";
        public static final String PT_BR = "pt-BR";
        public static final String PT_BR_BROADBANDMODEL = "pt-BR_BroadbandModel";
        public static final String PT_BR_MULTIMEDIA = "pt-BR_Multimedia";
        public static final String PT_BR_NARROWBANDMODEL = "pt-BR_NarrowbandModel";
        public static final String PT_BR_TELEPHONY = "pt-BR_Telephony";
        public static final String SV_SE_TELEPHONY = "sv-SE_Telephony";
        public static final String ZH_CN_TELEPHONY = "zh-CN_Telephony";
    }
}

