/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.speech_to_text.v1.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class RecognizeWithWebsocketsOptions
extends GenericModel {
    protected transient InputStream audio;
    @SerializedName(value="content-type")
    protected String contentType;
    protected String model;
    protected String languageCustomizationId;
    protected String acousticCustomizationId;
    protected String baseModelVersion;
    protected Double customizationWeight;
    protected Long inactivityTimeout;
    protected List<String> keywords;
    protected Float keywordsThreshold;
    protected Long maxAlternatives;
    protected Float wordAlternativesThreshold;
    protected Boolean wordConfidence;
    protected Boolean timestamps;
    protected Boolean profanityFilter;
    protected Boolean smartFormatting;
    protected Long smartFormattingVersion;
    protected Boolean speakerLabels;
    protected String grammarName;
    protected Boolean redaction;
    protected Boolean audioMetrics;
    protected Double endOfPhraseSilenceTime;
    protected Boolean splitTranscriptAtPhraseEnd;
    protected Float speechDetectorSensitivity;
    protected Float backgroundAudioSuppression;
    protected Boolean lowLatency;
    protected Float characterInsertionBias;
    private Boolean interimResults;
    private Boolean processingMetrics;
    private Float processingMetricsInterval;

    protected RecognizeWithWebsocketsOptions(Builder builder) {
        Validator.notNull((Object)builder.audio, (String)"audio cannot be null");
        this.audio = builder.audio;
        this.contentType = builder.contentType;
        this.model = builder.model;
        this.languageCustomizationId = builder.languageCustomizationId;
        this.acousticCustomizationId = builder.acousticCustomizationId;
        this.baseModelVersion = builder.baseModelVersion;
        this.customizationWeight = builder.customizationWeight;
        this.inactivityTimeout = builder.inactivityTimeout;
        this.keywords = builder.keywords;
        this.keywordsThreshold = builder.keywordsThreshold;
        this.maxAlternatives = builder.maxAlternatives;
        this.wordAlternativesThreshold = builder.wordAlternativesThreshold;
        this.wordConfidence = builder.wordConfidence;
        this.timestamps = builder.timestamps;
        this.profanityFilter = builder.profanityFilter;
        this.smartFormatting = builder.smartFormatting;
        this.smartFormattingVersion = builder.smartFormattingVersion;
        this.speakerLabels = builder.speakerLabels;
        this.grammarName = builder.grammarName;
        this.redaction = builder.redaction;
        this.audioMetrics = builder.audioMetrics;
        this.endOfPhraseSilenceTime = builder.endOfPhraseSilenceTime;
        this.splitTranscriptAtPhraseEnd = builder.splitTranscriptAtPhraseEnd;
        this.speechDetectorSensitivity = builder.speechDetectorSensitivity;
        this.backgroundAudioSuppression = builder.backgroundAudioSuppression;
        this.lowLatency = builder.lowLatency;
        this.characterInsertionBias = builder.characterInsertionBias;
        this.interimResults = builder.interimResults;
        this.processingMetrics = builder.processingMetrics;
        this.processingMetricsInterval = builder.processingMetricsInterval;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public InputStream audio() {
        return this.audio;
    }

    public String contentType() {
        return this.contentType;
    }

    public String model() {
        return this.model;
    }

    public String languageCustomizationId() {
        return this.languageCustomizationId;
    }

    public String acousticCustomizationId() {
        return this.acousticCustomizationId;
    }

    public String baseModelVersion() {
        return this.baseModelVersion;
    }

    public Double customizationWeight() {
        return this.customizationWeight;
    }

    public Long inactivityTimeout() {
        return this.inactivityTimeout;
    }

    public List<String> keywords() {
        return this.keywords;
    }

    public Float keywordsThreshold() {
        return this.keywordsThreshold;
    }

    public Long maxAlternatives() {
        return this.maxAlternatives;
    }

    public Float wordAlternativesThreshold() {
        return this.wordAlternativesThreshold;
    }

    public Boolean wordConfidence() {
        return this.wordConfidence;
    }

    public Boolean timestamps() {
        return this.timestamps;
    }

    public Boolean profanityFilter() {
        return this.profanityFilter;
    }

    public Boolean smartFormatting() {
        return this.smartFormatting;
    }

    public Long smartFormattingVersion() {
        return this.smartFormattingVersion;
    }

    public Boolean speakerLabels() {
        return this.speakerLabels;
    }

    public String grammarName() {
        return this.grammarName;
    }

    public Boolean redaction() {
        return this.redaction;
    }

    public Boolean audioMetrics() {
        return this.audioMetrics;
    }

    public Double endOfPhraseSilenceTime() {
        return this.endOfPhraseSilenceTime;
    }

    public Boolean splitTranscriptAtPhraseEnd() {
        return this.splitTranscriptAtPhraseEnd;
    }

    public Float speechDetectorSensitivity() {
        return this.speechDetectorSensitivity;
    }

    public Float backgroundAudioSuppression() {
        return this.backgroundAudioSuppression;
    }

    public Boolean lowLatency() {
        return this.lowLatency;
    }

    public Float characterInsertionBias() {
        return this.characterInsertionBias;
    }

    public Boolean interimResults() {
        return this.interimResults;
    }

    public Boolean processingMetrics() {
        return this.processingMetrics;
    }

    public Float processingMetricsInterval() {
        return this.processingMetricsInterval;
    }

    public static class Builder {
        private InputStream audio;
        private String contentType;
        private String model;
        private String languageCustomizationId;
        private String acousticCustomizationId;
        private String baseModelVersion;
        private Double customizationWeight;
        private Long inactivityTimeout;
        private List<String> keywords;
        private Float keywordsThreshold;
        private Long maxAlternatives;
        private Float wordAlternativesThreshold;
        private Boolean wordConfidence;
        private Boolean timestamps;
        private Boolean profanityFilter;
        private Boolean smartFormatting;
        private Long smartFormattingVersion;
        private Boolean speakerLabels;
        private String grammarName;
        private Boolean redaction;
        private Boolean audioMetrics;
        private Double endOfPhraseSilenceTime;
        private Boolean splitTranscriptAtPhraseEnd;
        private Float speechDetectorSensitivity;
        private Float backgroundAudioSuppression;
        private Boolean lowLatency;
        private Float characterInsertionBias;
        private Boolean interimResults;
        private Boolean processingMetrics;
        private Float processingMetricsInterval;

        private Builder(RecognizeWithWebsocketsOptions recognizeWithWebsocketsOptions) {
            this.audio = recognizeWithWebsocketsOptions.audio;
            this.contentType = recognizeWithWebsocketsOptions.contentType;
            this.model = recognizeWithWebsocketsOptions.model;
            this.languageCustomizationId = recognizeWithWebsocketsOptions.languageCustomizationId;
            this.acousticCustomizationId = recognizeWithWebsocketsOptions.acousticCustomizationId;
            this.baseModelVersion = recognizeWithWebsocketsOptions.baseModelVersion;
            this.customizationWeight = recognizeWithWebsocketsOptions.customizationWeight;
            this.inactivityTimeout = recognizeWithWebsocketsOptions.inactivityTimeout;
            this.keywords = recognizeWithWebsocketsOptions.keywords;
            this.keywordsThreshold = recognizeWithWebsocketsOptions.keywordsThreshold;
            this.maxAlternatives = recognizeWithWebsocketsOptions.maxAlternatives;
            this.wordAlternativesThreshold = recognizeWithWebsocketsOptions.wordAlternativesThreshold;
            this.wordConfidence = recognizeWithWebsocketsOptions.wordConfidence;
            this.timestamps = recognizeWithWebsocketsOptions.timestamps;
            this.profanityFilter = recognizeWithWebsocketsOptions.profanityFilter;
            this.smartFormatting = recognizeWithWebsocketsOptions.smartFormatting;
            this.smartFormattingVersion = recognizeWithWebsocketsOptions.smartFormattingVersion;
            this.speakerLabels = recognizeWithWebsocketsOptions.speakerLabels;
            this.grammarName = recognizeWithWebsocketsOptions.grammarName;
            this.redaction = recognizeWithWebsocketsOptions.redaction;
            this.audioMetrics = recognizeWithWebsocketsOptions.audioMetrics;
            this.endOfPhraseSilenceTime = recognizeWithWebsocketsOptions.endOfPhraseSilenceTime;
            this.splitTranscriptAtPhraseEnd = recognizeWithWebsocketsOptions.splitTranscriptAtPhraseEnd;
            this.speechDetectorSensitivity = recognizeWithWebsocketsOptions.speechDetectorSensitivity;
            this.backgroundAudioSuppression = recognizeWithWebsocketsOptions.backgroundAudioSuppression;
            this.lowLatency = recognizeWithWebsocketsOptions.lowLatency;
            this.characterInsertionBias = recognizeWithWebsocketsOptions.characterInsertionBias;
            this.interimResults = recognizeWithWebsocketsOptions.interimResults;
            this.processingMetrics = recognizeWithWebsocketsOptions.processingMetrics;
            this.processingMetricsInterval = recognizeWithWebsocketsOptions.processingMetricsInterval;
        }

        public Builder() {
        }

        public Builder(InputStream audio) {
            this.audio = audio;
        }

        public RecognizeWithWebsocketsOptions build() {
            return new RecognizeWithWebsocketsOptions(this);
        }

        public Builder addKeyword(String keyword) {
            Validator.notNull((Object)keyword, (String)"keyword cannot be null");
            if (this.keywords == null) {
                this.keywords = new ArrayList<String>();
            }
            this.keywords.add(keyword);
            return this;
        }

        public Builder audio(InputStream audio) {
            this.audio = audio;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder languageCustomizationId(String languageCustomizationId) {
            this.languageCustomizationId = languageCustomizationId;
            return this;
        }

        public Builder acousticCustomizationId(String acousticCustomizationId) {
            this.acousticCustomizationId = acousticCustomizationId;
            return this;
        }

        public Builder baseModelVersion(String baseModelVersion) {
            this.baseModelVersion = baseModelVersion;
            return this;
        }

        public Builder customizationWeight(Double customizationWeight) {
            this.customizationWeight = customizationWeight;
            return this;
        }

        public Builder inactivityTimeout(long inactivityTimeout) {
            this.inactivityTimeout = inactivityTimeout;
            return this;
        }

        public Builder keywords(List<String> keywords) {
            this.keywords = keywords;
            return this;
        }

        public Builder keywordsThreshold(Float keywordsThreshold) {
            this.keywordsThreshold = keywordsThreshold;
            return this;
        }

        public Builder maxAlternatives(long maxAlternatives) {
            this.maxAlternatives = maxAlternatives;
            return this;
        }

        public Builder wordAlternativesThreshold(Float wordAlternativesThreshold) {
            this.wordAlternativesThreshold = wordAlternativesThreshold;
            return this;
        }

        public Builder wordConfidence(Boolean wordConfidence) {
            this.wordConfidence = wordConfidence;
            return this;
        }

        public Builder timestamps(Boolean timestamps) {
            this.timestamps = timestamps;
            return this;
        }

        public Builder profanityFilter(Boolean profanityFilter) {
            this.profanityFilter = profanityFilter;
            return this;
        }

        public Builder smartFormatting(Boolean smartFormatting) {
            this.smartFormatting = smartFormatting;
            return this;
        }

        public Builder smartFormattingVersion(long smartFormattingVersion) {
            this.smartFormattingVersion = smartFormattingVersion;
            return this;
        }

        public Builder speakerLabels(Boolean speakerLabels) {
            this.speakerLabels = speakerLabels;
            return this;
        }

        public Builder grammarName(String grammarName) {
            this.grammarName = grammarName;
            return this;
        }

        public Builder redaction(Boolean redaction) {
            this.redaction = redaction;
            return this;
        }

        public Builder audioMetrics(Boolean audioMetrics) {
            this.audioMetrics = audioMetrics;
            return this;
        }

        public Builder endOfPhraseSilenceTime(Double endOfPhraseSilenceTime) {
            this.endOfPhraseSilenceTime = endOfPhraseSilenceTime;
            return this;
        }

        public Builder splitTranscriptAtPhraseEnd(Boolean splitTranscriptAtPhraseEnd) {
            this.splitTranscriptAtPhraseEnd = splitTranscriptAtPhraseEnd;
            return this;
        }

        public Builder speechDetectorSensitivity(Float speechDetectorSensitivity) {
            this.speechDetectorSensitivity = speechDetectorSensitivity;
            return this;
        }

        public Builder backgroundAudioSuppression(Float backgroundAudioSuppression) {
            this.backgroundAudioSuppression = backgroundAudioSuppression;
            return this;
        }

        public Builder lowLatency(Boolean lowLatency) {
            this.lowLatency = lowLatency;
            return this;
        }

        public Builder characterInsertionBias(Float characterInsertionBias) {
            this.characterInsertionBias = characterInsertionBias;
            return this;
        }

        public Builder interimResults(Boolean interimResults) {
            this.interimResults = interimResults;
            return this;
        }

        public Builder audio(File audio) throws FileNotFoundException {
            this.audio = new FileInputStream(audio);
            return this;
        }

        public Builder processingMetrics(Boolean processingMetrics) {
            this.processingMetrics = processingMetrics;
            return this;
        }

        public Builder processingMetricsInterval(Float processingMetricsInterval) {
            this.processingMetricsInterval = processingMetricsInterval;
            return this;
        }
    }

    public static interface Model {
        public static final String AR_MS_BROADBANDMODEL = "ar-MS_BroadbandModel";
        public static final String AR_MS_TELEPHONY = "ar-MS_Telephony";
        public static final String CS_CZ_TELEPHONY = "cs-CZ_Telephony";
        public static final String DE_DE_BROADBANDMODEL = "de-DE_BroadbandModel";
        public static final String DE_DE_MULTIMEDIA = "de-DE_Multimedia";
        public static final String DE_DE_NARROWBANDMODEL = "de-DE_NarrowbandModel";
        public static final String DE_DE_TELEPHONY = "de-DE_Telephony";
        public static final String EN_AU_BROADBANDMODEL = "en-AU_BroadbandModel";
        public static final String EN_AU_MULTIMEDIA = "en-AU_Multimedia";
        public static final String EN_AU_NARROWBANDMODEL = "en-AU_NarrowbandModel";
        public static final String EN_AU_TELEPHONY = "en-AU_Telephony";
        public static final String EN_IN_TELEPHONY = "en-IN_Telephony";
        public static final String EN_GB_BROADBANDMODEL = "en-GB_BroadbandModel";
        public static final String EN_GB_MULTIMEDIA = "en-GB_Multimedia";
        public static final String EN_GB_NARROWBANDMODEL = "en-GB_NarrowbandModel";
        public static final String EN_GB_TELEPHONY = "en-GB_Telephony";
        public static final String EN_US_BROADBANDMODEL = "en-US_BroadbandModel";
        public static final String EN_US_MULTIMEDIA = "en-US_Multimedia";
        public static final String EN_US_NARROWBANDMODEL = "en-US_NarrowbandModel";
        public static final String EN_US_SHORTFORM_NARROWBANDMODEL = "en-US_ShortForm_NarrowbandModel";
        public static final String EN_US_TELEPHONY = "en-US_Telephony";
        public static final String EN_WW_MEDICAL_TELEPHONY = "en-WW_Medical_Telephony";
        public static final String ES_AR_BROADBANDMODEL = "es-AR_BroadbandModel";
        public static final String ES_AR_NARROWBANDMODEL = "es-AR_NarrowbandModel";
        public static final String ES_CL_BROADBANDMODEL = "es-CL_BroadbandModel";
        public static final String ES_CL_NARROWBANDMODEL = "es-CL_NarrowbandModel";
        public static final String ES_CO_BROADBANDMODEL = "es-CO_BroadbandModel";
        public static final String ES_CO_NARROWBANDMODEL = "es-CO_NarrowbandModel";
        public static final String ES_ES_BROADBANDMODEL = "es-ES_BroadbandModel";
        public static final String ES_ES_NARROWBANDMODEL = "es-ES_NarrowbandModel";
        public static final String ES_ES_MULTIMEDIA = "es-ES_Multimedia";
        public static final String ES_ES_TELEPHONY = "es-ES_Telephony";
        public static final String ES_LA_TELEPHONY = "es-LA_Telephony";
        public static final String ES_MX_BROADBANDMODEL = "es-MX_BroadbandModel";
        public static final String ES_MX_NARROWBANDMODEL = "es-MX_NarrowbandModel";
        public static final String ES_PE_BROADBANDMODEL = "es-PE_BroadbandModel";
        public static final String ES_PE_NARROWBANDMODEL = "es-PE_NarrowbandModel";
        public static final String FR_CA_BROADBANDMODEL = "fr-CA_BroadbandModel";
        public static final String FR_CA_MULTIMEDIA = "fr-CA_Multimedia";
        public static final String FR_CA_NARROWBANDMODEL = "fr-CA_NarrowbandModel";
        public static final String FR_CA_TELEPHONY = "fr-CA_Telephony";
        public static final String FR_FR_BROADBANDMODEL = "fr-FR_BroadbandModel";
        public static final String FR_FR_MULTIMEDIA = "fr-FR_Multimedia";
        public static final String FR_FR_NARROWBANDMODEL = "fr-FR_NarrowbandModel";
        public static final String FR_FR_TELEPHONY = "fr-FR_Telephony";
        public static final String HI_IN_TELEPHONY = "hi-IN_Telephony";
        public static final String IT_IT_BROADBANDMODEL = "it-IT_BroadbandModel";
        public static final String IT_IT_NARROWBANDMODEL = "it-IT_NarrowbandModel";
        public static final String IT_IT_MULTIMEDIA = "it-IT_Multimedia";
        public static final String IT_IT_TELEPHONY = "it-IT_Telephony";
        public static final String JA_JP_BROADBANDMODEL = "ja-JP_BroadbandModel";
        public static final String JA_JP_MULTIMEDIA = "ja-JP_Multimedia";
        public static final String JA_JP_NARROWBANDMODEL = "ja-JP_NarrowbandModel";
        public static final String JA_JP_TELEPHONY = "ja-JP_Telephony";
        public static final String KO_KR_BROADBANDMODEL = "ko-KR_BroadbandModel";
        public static final String KO_KR_MULTIMEDIA = "ko-KR_Multimedia";
        public static final String KO_KR_NARROWBANDMODEL = "ko-KR_NarrowbandModel";
        public static final String KO_KR_TELEPHONY = "ko-KR_Telephony";
        public static final String NL_BE_TELEPHONY = "nl-BE_Telephony";
        public static final String NL_NL_BROADBANDMODEL = "nl-NL_BroadbandModel";
        public static final String NL_NL_MULTIMEDIA = "nl-NL_Multimedia";
        public static final String NL_NL_NARROWBANDMODEL = "nl-NL_NarrowbandModel";
        public static final String NL_NL_TELEPHONY = "nl-NL_Telephony";
        public static final String PT_BR_BROADBANDMODEL = "pt-BR_BroadbandModel";
        public static final String PT_BR_MULTIMEDIA = "pt-BR_Multimedia";
        public static final String PT_BR_NARROWBANDMODEL = "pt-BR_NarrowbandModel";
        public static final String PT_BR_TELEPHONY = "pt-BR_Telephony";
        public static final String SV_SE_TELEPHONY = "sv-SE_Telephony";
        public static final String ZH_CN_BROADBANDMODEL = "zh-CN_BroadbandModel";
        public static final String ZH_CN_NARROWBANDMODEL = "zh-CN_NarrowbandModel";
        public static final String ZH_CN_TELEPHONY = "zh-CN_Telephony";
    }
}

