/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.speech_to_text.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class AddCorpusOptions
extends GenericModel {
    private String customizationId;
    private String corpusName;
    private InputStream corpusFile;
    private Boolean allowOverwrite;

    private AddCorpusOptions(Builder builder) {
        Validator.notEmpty((String)builder.customizationId, (String)"customizationId cannot be empty");
        Validator.notEmpty((String)builder.corpusName, (String)"corpusName cannot be empty");
        Validator.notNull((Object)builder.corpusFile, (String)"corpusFile cannot be null");
        this.customizationId = builder.customizationId;
        this.corpusName = builder.corpusName;
        this.corpusFile = builder.corpusFile;
        this.allowOverwrite = builder.allowOverwrite;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String customizationId() {
        return this.customizationId;
    }

    public String corpusName() {
        return this.corpusName;
    }

    public InputStream corpusFile() {
        return this.corpusFile;
    }

    public Boolean allowOverwrite() {
        return this.allowOverwrite;
    }

    public static class Builder {
        private String customizationId;
        private String corpusName;
        private InputStream corpusFile;
        private Boolean allowOverwrite;

        private Builder(AddCorpusOptions addCorpusOptions) {
            this.customizationId = addCorpusOptions.customizationId;
            this.corpusName = addCorpusOptions.corpusName;
            this.corpusFile = addCorpusOptions.corpusFile;
            this.allowOverwrite = addCorpusOptions.allowOverwrite;
        }

        public Builder() {
        }

        public Builder(String customizationId, String corpusName, InputStream corpusFile) {
            this.customizationId = customizationId;
            this.corpusName = corpusName;
            this.corpusFile = corpusFile;
        }

        public AddCorpusOptions build() {
            return new AddCorpusOptions(this);
        }

        public Builder customizationId(String customizationId) {
            this.customizationId = customizationId;
            return this;
        }

        public Builder corpusName(String corpusName) {
            this.corpusName = corpusName;
            return this;
        }

        public Builder corpusFile(InputStream corpusFile) {
            this.corpusFile = corpusFile;
            return this;
        }

        public Builder allowOverwrite(Boolean allowOverwrite) {
            this.allowOverwrite = allowOverwrite;
            return this;
        }

        public Builder corpusFile(File corpusFile) throws FileNotFoundException {
            this.corpusFile = new FileInputStream(corpusFile);
            return this;
        }
    }
}

