/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.speech_to_text.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class AddWordOptions
extends GenericModel {
    private String customizationId;
    private String wordName;
    private String word;
    private List<String> soundsLike;
    private String displayAs;

    private AddWordOptions(Builder builder) {
        Validator.notEmpty((String)builder.customizationId, (String)"customizationId cannot be empty");
        Validator.notEmpty((String)builder.wordName, (String)"wordName cannot be empty");
        this.customizationId = builder.customizationId;
        this.wordName = builder.wordName;
        this.word = builder.word;
        this.soundsLike = builder.soundsLike;
        this.displayAs = builder.displayAs;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String customizationId() {
        return this.customizationId;
    }

    public String wordName() {
        return this.wordName;
    }

    public String word() {
        return this.word;
    }

    public List<String> soundsLike() {
        return this.soundsLike;
    }

    public String displayAs() {
        return this.displayAs;
    }

    public static class Builder {
        private String customizationId;
        private String wordName;
        private String word;
        private List<String> soundsLike;
        private String displayAs;

        private Builder(AddWordOptions addWordOptions) {
            this.customizationId = addWordOptions.customizationId;
            this.wordName = addWordOptions.wordName;
            this.word = addWordOptions.word;
            this.soundsLike = addWordOptions.soundsLike;
            this.displayAs = addWordOptions.displayAs;
        }

        public Builder() {
        }

        public Builder(String customizationId, String wordName) {
            this.customizationId = customizationId;
            this.wordName = wordName;
        }

        public AddWordOptions build() {
            return new AddWordOptions(this);
        }

        public Builder addSoundsLike(String soundsLike) {
            Validator.notNull((Object)soundsLike, (String)"soundsLike cannot be null");
            if (this.soundsLike == null) {
                this.soundsLike = new ArrayList<String>();
            }
            this.soundsLike.add(soundsLike);
            return this;
        }

        public Builder customizationId(String customizationId) {
            this.customizationId = customizationId;
            return this;
        }

        public Builder wordName(String wordName) {
            this.wordName = wordName;
            return this;
        }

        public Builder word(String word) {
            this.word = word;
            return this;
        }

        public Builder soundsLike(List<String> soundsLike) {
            this.soundsLike = soundsLike;
            return this;
        }

        public Builder displayAs(String displayAs) {
            this.displayAs = displayAs;
            return this;
        }
    }
}

