/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.speech_to_text.v1.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class CustomWord
extends GenericModel {
    private String word;
    @SerializedName(value="sounds_like")
    private List<String> soundsLike;
    @SerializedName(value="display_as")
    private String displayAs;

    private CustomWord(Builder builder) {
        this.word = builder.word;
        this.soundsLike = builder.soundsLike;
        this.displayAs = builder.displayAs;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String word() {
        return this.word;
    }

    public List<String> soundsLike() {
        return this.soundsLike;
    }

    public String displayAs() {
        return this.displayAs;
    }

    public static class Builder {
        private String word;
        private List<String> soundsLike;
        private String displayAs;

        private Builder(CustomWord customWord) {
            this.word = customWord.word;
            this.soundsLike = customWord.soundsLike;
            this.displayAs = customWord.displayAs;
        }

        public Builder() {
        }

        public CustomWord build() {
            return new CustomWord(this);
        }

        public Builder addSoundsLike(String soundsLike) {
            Validator.notNull((Object)soundsLike, (String)"soundsLike cannot be null");
            if (this.soundsLike == null) {
                this.soundsLike = new ArrayList<String>();
            }
            this.soundsLike.add(soundsLike);
            return this;
        }

        public Builder word(String word) {
            this.word = word;
            return this;
        }

        public Builder soundsLike(List<String> soundsLike) {
            this.soundsLike = soundsLike;
            return this;
        }

        public Builder displayAs(String displayAs) {
            this.displayAs = displayAs;
            return this;
        }
    }
}

