/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.speech_to_text.v1.model;

import com.google.gson.annotations.SerializedName;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class RecognizeOptions
extends GenericModel {
    private transient InputStream audio;
    @SerializedName(value="content-type")
    private String contentType;
    private String model;
    private String languageCustomizationId;
    private String acousticCustomizationId;
    private String baseModelVersion;
    private Double customizationWeight;
    private Long inactivityTimeout;
    private List<String> keywords;
    private Float keywordsThreshold;
    private Long maxAlternatives;
    private Float wordAlternativesThreshold;
    private Boolean wordConfidence;
    private Boolean timestamps;
    private Boolean profanityFilter;
    private Boolean smartFormatting;
    private Boolean speakerLabels;
    private String customizationId;
    private String grammarName;
    private Boolean redaction;
    private Boolean audioMetrics;
    private Boolean interimResults;
    private Boolean processingMetrics;
    private Float processingMetricsInterval;

    private RecognizeOptions(Builder builder) {
        Validator.notNull((Object)builder.audio, (String)"audio cannot be null");
        this.audio = builder.audio;
        this.contentType = builder.contentType;
        this.model = builder.model;
        this.languageCustomizationId = builder.languageCustomizationId;
        this.acousticCustomizationId = builder.acousticCustomizationId;
        this.baseModelVersion = builder.baseModelVersion;
        this.customizationWeight = builder.customizationWeight;
        this.inactivityTimeout = builder.inactivityTimeout;
        this.keywords = builder.keywords;
        this.keywordsThreshold = builder.keywordsThreshold;
        this.maxAlternatives = builder.maxAlternatives;
        this.wordAlternativesThreshold = builder.wordAlternativesThreshold;
        this.wordConfidence = builder.wordConfidence;
        this.timestamps = builder.timestamps;
        this.profanityFilter = builder.profanityFilter;
        this.smartFormatting = builder.smartFormatting;
        this.speakerLabels = builder.speakerLabels;
        this.customizationId = builder.customizationId;
        this.grammarName = builder.grammarName;
        this.redaction = builder.redaction;
        this.audioMetrics = builder.audioMetrics;
        this.interimResults = builder.interimResults;
        this.processingMetrics = builder.processingMetrics;
        this.processingMetricsInterval = builder.processingMetricsInterval;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public InputStream audio() {
        return this.audio;
    }

    public String contentType() {
        return this.contentType;
    }

    public String model() {
        return this.model;
    }

    public String languageCustomizationId() {
        return this.languageCustomizationId;
    }

    public String acousticCustomizationId() {
        return this.acousticCustomizationId;
    }

    public String baseModelVersion() {
        return this.baseModelVersion;
    }

    public Double customizationWeight() {
        return this.customizationWeight;
    }

    public Long inactivityTimeout() {
        return this.inactivityTimeout;
    }

    public List<String> keywords() {
        return this.keywords;
    }

    public Float keywordsThreshold() {
        return this.keywordsThreshold;
    }

    public Long maxAlternatives() {
        return this.maxAlternatives;
    }

    public Float wordAlternativesThreshold() {
        return this.wordAlternativesThreshold;
    }

    public Boolean wordConfidence() {
        return this.wordConfidence;
    }

    public Boolean timestamps() {
        return this.timestamps;
    }

    public Boolean profanityFilter() {
        return this.profanityFilter;
    }

    public Boolean smartFormatting() {
        return this.smartFormatting;
    }

    public Boolean speakerLabels() {
        return this.speakerLabels;
    }

    public String customizationId() {
        return this.customizationId;
    }

    public String grammarName() {
        return this.grammarName;
    }

    public Boolean redaction() {
        return this.redaction;
    }

    public Boolean audioMetrics() {
        return this.audioMetrics;
    }

    public Boolean interimResults() {
        return this.interimResults;
    }

    public Boolean processingMetrics() {
        return this.processingMetrics;
    }

    public Float processingMetricsInterval() {
        return this.processingMetricsInterval;
    }

    public static class Builder {
        private InputStream audio;
        private String contentType;
        private String model;
        private String languageCustomizationId;
        private String acousticCustomizationId;
        private String baseModelVersion;
        private Double customizationWeight;
        private Long inactivityTimeout;
        private List<String> keywords;
        private Float keywordsThreshold;
        private Long maxAlternatives;
        private Float wordAlternativesThreshold;
        private Boolean wordConfidence;
        private Boolean timestamps;
        private Boolean profanityFilter;
        private Boolean smartFormatting;
        private Boolean speakerLabels;
        private String customizationId;
        private String grammarName;
        private Boolean redaction;
        private Boolean audioMetrics;
        private Boolean interimResults;
        private Boolean processingMetrics;
        private Float processingMetricsInterval;

        private Builder(RecognizeOptions recognizeOptions) {
            this.audio = recognizeOptions.audio;
            this.contentType = recognizeOptions.contentType;
            this.model = recognizeOptions.model;
            this.languageCustomizationId = recognizeOptions.languageCustomizationId;
            this.acousticCustomizationId = recognizeOptions.acousticCustomizationId;
            this.baseModelVersion = recognizeOptions.baseModelVersion;
            this.customizationWeight = recognizeOptions.customizationWeight;
            this.inactivityTimeout = recognizeOptions.inactivityTimeout;
            this.keywords = recognizeOptions.keywords;
            this.keywordsThreshold = recognizeOptions.keywordsThreshold;
            this.maxAlternatives = recognizeOptions.maxAlternatives;
            this.wordAlternativesThreshold = recognizeOptions.wordAlternativesThreshold;
            this.wordConfidence = recognizeOptions.wordConfidence;
            this.timestamps = recognizeOptions.timestamps;
            this.profanityFilter = recognizeOptions.profanityFilter;
            this.smartFormatting = recognizeOptions.smartFormatting;
            this.speakerLabels = recognizeOptions.speakerLabels;
            this.customizationId = recognizeOptions.customizationId;
            this.grammarName = recognizeOptions.grammarName;
            this.redaction = recognizeOptions.redaction;
            this.audioMetrics = recognizeOptions.audioMetrics;
            this.interimResults = recognizeOptions.interimResults;
            this.processingMetrics = recognizeOptions.processingMetrics;
            this.processingMetricsInterval = recognizeOptions.processingMetricsInterval;
        }

        public Builder() {
        }

        public Builder(InputStream audio) {
            this.audio = audio;
        }

        public RecognizeOptions build() {
            return new RecognizeOptions(this);
        }

        public Builder addKeyword(String keyword) {
            Validator.notNull((Object)keyword, (String)"keyword cannot be null");
            if (this.keywords == null) {
                this.keywords = new ArrayList<String>();
            }
            this.keywords.add(keyword);
            return this;
        }

        public Builder audio(InputStream audio) {
            this.audio = audio;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder languageCustomizationId(String languageCustomizationId) {
            this.languageCustomizationId = languageCustomizationId;
            return this;
        }

        public Builder acousticCustomizationId(String acousticCustomizationId) {
            this.acousticCustomizationId = acousticCustomizationId;
            return this;
        }

        public Builder baseModelVersion(String baseModelVersion) {
            this.baseModelVersion = baseModelVersion;
            return this;
        }

        public Builder customizationWeight(Double customizationWeight) {
            this.customizationWeight = customizationWeight;
            return this;
        }

        public Builder inactivityTimeout(long inactivityTimeout) {
            this.inactivityTimeout = inactivityTimeout;
            return this;
        }

        public Builder keywords(List<String> keywords) {
            this.keywords = keywords;
            return this;
        }

        public Builder keywordsThreshold(Float keywordsThreshold) {
            this.keywordsThreshold = keywordsThreshold;
            return this;
        }

        public Builder maxAlternatives(long maxAlternatives) {
            this.maxAlternatives = maxAlternatives;
            return this;
        }

        public Builder wordAlternativesThreshold(Float wordAlternativesThreshold) {
            this.wordAlternativesThreshold = wordAlternativesThreshold;
            return this;
        }

        public Builder wordConfidence(Boolean wordConfidence) {
            this.wordConfidence = wordConfidence;
            return this;
        }

        public Builder timestamps(Boolean timestamps) {
            this.timestamps = timestamps;
            return this;
        }

        public Builder profanityFilter(Boolean profanityFilter) {
            this.profanityFilter = profanityFilter;
            return this;
        }

        public Builder smartFormatting(Boolean smartFormatting) {
            this.smartFormatting = smartFormatting;
            return this;
        }

        public Builder speakerLabels(Boolean speakerLabels) {
            this.speakerLabels = speakerLabels;
            return this;
        }

        public Builder customizationId(String customizationId) {
            this.customizationId = customizationId;
            return this;
        }

        public Builder grammarName(String grammarName) {
            this.grammarName = grammarName;
            return this;
        }

        public Builder redaction(Boolean redaction) {
            this.redaction = redaction;
            return this;
        }

        public Builder audioMetrics(Boolean audioMetrics) {
            this.audioMetrics = audioMetrics;
            return this;
        }

        public Builder audio(File audio) throws FileNotFoundException {
            this.audio = new FileInputStream(audio);
            return this;
        }

        public Builder interimResults(Boolean interimResults) {
            this.interimResults = interimResults;
            return this;
        }

        public Builder processingMetrics(Boolean processingMetrics) {
            this.processingMetrics = processingMetrics;
            return this;
        }

        public Builder processingMetricsInterval(Float processingMetricsInterval) {
            this.processingMetricsInterval = processingMetricsInterval;
            return this;
        }
    }

    public static interface Model {
        public static final String AR_AR_BROADBANDMODEL = "ar-AR_BroadbandModel";
        public static final String DE_DE_BROADBANDMODEL = "de-DE_BroadbandModel";
        public static final String DE_DE_NARROWBANDMODEL = "de-DE_NarrowbandModel";
        public static final String EN_GB_BROADBANDMODEL = "en-GB_BroadbandModel";
        public static final String EN_GB_NARROWBANDMODEL = "en-GB_NarrowbandModel";
        public static final String EN_US_BROADBANDMODEL = "en-US_BroadbandModel";
        public static final String EN_US_NARROWBANDMODEL = "en-US_NarrowbandModel";
        public static final String EN_US_SHORTFORM_NARROWBANDMODEL = "en-US_ShortForm_NarrowbandModel";
        public static final String ES_AR_BROADBANDMODEL = "es-AR_BroadbandModel";
        public static final String ES_AR_NARROWBANDMODEL = "es-AR_NarrowbandModel";
        public static final String ES_CL_BROADBANDMODEL = "es-CL_BroadbandModel";
        public static final String ES_CL_NARROWBANDMODEL = "es-CL_NarrowbandModel";
        public static final String ES_CO_BROADBANDMODEL = "es-CO_BroadbandModel";
        public static final String ES_CO_NARROWBANDMODEL = "es-CO_NarrowbandModel";
        public static final String ES_ES_BROADBANDMODEL = "es-ES_BroadbandModel";
        public static final String ES_ES_NARROWBANDMODEL = "es-ES_NarrowbandModel";
        public static final String ES_MX_BROADBANDMODEL = "es-MX_BroadbandModel";
        public static final String ES_MX_NARROWBANDMODEL = "es-MX_NarrowbandModel";
        public static final String ES_PE_BROADBANDMODEL = "es-PE_BroadbandModel";
        public static final String ES_PE_NARROWBANDMODEL = "es-PE_NarrowbandModel";
        public static final String FR_FR_BROADBANDMODEL = "fr-FR_BroadbandModel";
        public static final String FR_FR_NARROWBANDMODEL = "fr-FR_NarrowbandModel";
        public static final String JA_JP_BROADBANDMODEL = "ja-JP_BroadbandModel";
        public static final String JA_JP_NARROWBANDMODEL = "ja-JP_NarrowbandModel";
        public static final String KO_KR_BROADBANDMODEL = "ko-KR_BroadbandModel";
        public static final String KO_KR_NARROWBANDMODEL = "ko-KR_NarrowbandModel";
        public static final String PT_BR_BROADBANDMODEL = "pt-BR_BroadbandModel";
        public static final String PT_BR_NARROWBANDMODEL = "pt-BR_NarrowbandModel";
        public static final String ZH_CN_BROADBANDMODEL = "zh-CN_BroadbandModel";
        public static final String ZH_CN_NARROWBANDMODEL = "zh-CN_NarrowbandModel";
    }
}

