/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.speech_to_text.v1;

import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.http.ResponseConverter;
import com.ibm.cloud.sdk.core.http.ServiceCall;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.ConfigBasedAuthenticatorFactory;
import com.ibm.cloud.sdk.core.service.BaseService;
import com.ibm.cloud.sdk.core.util.GsonSingleton;
import com.ibm.cloud.sdk.core.util.RequestUtils;
import com.ibm.cloud.sdk.core.util.ResponseConverterUtils;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.common.SdkCommon;
import com.ibm.watson.speech_to_text.v1.model.AcousticModel;
import com.ibm.watson.speech_to_text.v1.model.AcousticModels;
import com.ibm.watson.speech_to_text.v1.model.AddAudioOptions;
import com.ibm.watson.speech_to_text.v1.model.AddCorpusOptions;
import com.ibm.watson.speech_to_text.v1.model.AddGrammarOptions;
import com.ibm.watson.speech_to_text.v1.model.AddWordOptions;
import com.ibm.watson.speech_to_text.v1.model.AddWordsOptions;
import com.ibm.watson.speech_to_text.v1.model.AudioListing;
import com.ibm.watson.speech_to_text.v1.model.AudioResources;
import com.ibm.watson.speech_to_text.v1.model.CheckJobOptions;
import com.ibm.watson.speech_to_text.v1.model.CheckJobsOptions;
import com.ibm.watson.speech_to_text.v1.model.Corpora;
import com.ibm.watson.speech_to_text.v1.model.Corpus;
import com.ibm.watson.speech_to_text.v1.model.CreateAcousticModelOptions;
import com.ibm.watson.speech_to_text.v1.model.CreateJobOptions;
import com.ibm.watson.speech_to_text.v1.model.CreateLanguageModelOptions;
import com.ibm.watson.speech_to_text.v1.model.DeleteAcousticModelOptions;
import com.ibm.watson.speech_to_text.v1.model.DeleteAudioOptions;
import com.ibm.watson.speech_to_text.v1.model.DeleteCorpusOptions;
import com.ibm.watson.speech_to_text.v1.model.DeleteGrammarOptions;
import com.ibm.watson.speech_to_text.v1.model.DeleteJobOptions;
import com.ibm.watson.speech_to_text.v1.model.DeleteLanguageModelOptions;
import com.ibm.watson.speech_to_text.v1.model.DeleteUserDataOptions;
import com.ibm.watson.speech_to_text.v1.model.DeleteWordOptions;
import com.ibm.watson.speech_to_text.v1.model.GetAcousticModelOptions;
import com.ibm.watson.speech_to_text.v1.model.GetAudioOptions;
import com.ibm.watson.speech_to_text.v1.model.GetCorpusOptions;
import com.ibm.watson.speech_to_text.v1.model.GetGrammarOptions;
import com.ibm.watson.speech_to_text.v1.model.GetLanguageModelOptions;
import com.ibm.watson.speech_to_text.v1.model.GetModelOptions;
import com.ibm.watson.speech_to_text.v1.model.GetWordOptions;
import com.ibm.watson.speech_to_text.v1.model.Grammar;
import com.ibm.watson.speech_to_text.v1.model.Grammars;
import com.ibm.watson.speech_to_text.v1.model.LanguageModel;
import com.ibm.watson.speech_to_text.v1.model.LanguageModels;
import com.ibm.watson.speech_to_text.v1.model.ListAcousticModelsOptions;
import com.ibm.watson.speech_to_text.v1.model.ListAudioOptions;
import com.ibm.watson.speech_to_text.v1.model.ListCorporaOptions;
import com.ibm.watson.speech_to_text.v1.model.ListGrammarsOptions;
import com.ibm.watson.speech_to_text.v1.model.ListLanguageModelsOptions;
import com.ibm.watson.speech_to_text.v1.model.ListModelsOptions;
import com.ibm.watson.speech_to_text.v1.model.ListWordsOptions;
import com.ibm.watson.speech_to_text.v1.model.RecognitionJob;
import com.ibm.watson.speech_to_text.v1.model.RecognitionJobs;
import com.ibm.watson.speech_to_text.v1.model.RecognizeOptions;
import com.ibm.watson.speech_to_text.v1.model.RegisterCallbackOptions;
import com.ibm.watson.speech_to_text.v1.model.RegisterStatus;
import com.ibm.watson.speech_to_text.v1.model.ResetAcousticModelOptions;
import com.ibm.watson.speech_to_text.v1.model.ResetLanguageModelOptions;
import com.ibm.watson.speech_to_text.v1.model.SpeechModel;
import com.ibm.watson.speech_to_text.v1.model.SpeechModels;
import com.ibm.watson.speech_to_text.v1.model.SpeechRecognitionResults;
import com.ibm.watson.speech_to_text.v1.model.TrainAcousticModelOptions;
import com.ibm.watson.speech_to_text.v1.model.TrainLanguageModelOptions;
import com.ibm.watson.speech_to_text.v1.model.TrainingResponse;
import com.ibm.watson.speech_to_text.v1.model.UnregisterCallbackOptions;
import com.ibm.watson.speech_to_text.v1.model.UpgradeAcousticModelOptions;
import com.ibm.watson.speech_to_text.v1.model.UpgradeLanguageModelOptions;
import com.ibm.watson.speech_to_text.v1.model.Word;
import com.ibm.watson.speech_to_text.v1.model.Words;
import com.ibm.watson.speech_to_text.v1.websocket.RecognizeCallback;
import com.ibm.watson.speech_to_text.v1.websocket.SpeechToTextWebSocketListener;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;

public class SpeechToText
extends BaseService {
    private static final String DEFAULT_SERVICE_NAME = "speech_to_text";
    private static final String DEFAULT_SERVICE_URL = "https://stream.watsonplatform.net/speech-to-text/api";

    public SpeechToText() {
        this(DEFAULT_SERVICE_NAME, ConfigBasedAuthenticatorFactory.getAuthenticator((String)DEFAULT_SERVICE_NAME));
    }

    public SpeechToText(Authenticator authenticator) {
        this(DEFAULT_SERVICE_NAME, authenticator);
    }

    public SpeechToText(String serviceName) {
        this(serviceName, ConfigBasedAuthenticatorFactory.getAuthenticator((String)serviceName));
    }

    public SpeechToText(String serviceName, Authenticator authenticator) {
        super(serviceName, authenticator);
        this.setServiceUrl(DEFAULT_SERVICE_URL);
        this.configureService(serviceName);
    }

    public ServiceCall<SpeechModels> listModels(ListModelsOptions listModelsOptions) {
        String[] pathSegments = new String[]{"v1/models"};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"listModels");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (listModelsOptions != null) {
            // empty if block
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<SpeechModels>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SpeechModels> listModels() {
        return this.listModels(null);
    }

    public ServiceCall<SpeechModel> getModel(GetModelOptions getModelOptions) {
        Validator.notNull((Object)((Object)getModelOptions), (String)"getModelOptions cannot be null");
        String[] pathSegments = new String[]{"v1/models"};
        String[] pathParameters = new String[]{getModelOptions.modelId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getModel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<SpeechModel>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SpeechRecognitionResults> recognize(RecognizeOptions recognizeOptions) {
        Validator.notNull((Object)((Object)recognizeOptions), (String)"recognizeOptions cannot be null");
        String[] pathSegments = new String[]{"v1/recognize"};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"recognize");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (recognizeOptions.contentType() != null) {
            builder.header(new Object[]{"Content-Type", recognizeOptions.contentType()});
        }
        if (recognizeOptions.model() != null) {
            builder.query(new Object[]{"model", recognizeOptions.model()});
        }
        if (recognizeOptions.languageCustomizationId() != null) {
            builder.query(new Object[]{"language_customization_id", recognizeOptions.languageCustomizationId()});
        }
        if (recognizeOptions.acousticCustomizationId() != null) {
            builder.query(new Object[]{"acoustic_customization_id", recognizeOptions.acousticCustomizationId()});
        }
        if (recognizeOptions.baseModelVersion() != null) {
            builder.query(new Object[]{"base_model_version", recognizeOptions.baseModelVersion()});
        }
        if (recognizeOptions.customizationWeight() != null) {
            builder.query(new Object[]{"customization_weight", String.valueOf(recognizeOptions.customizationWeight())});
        }
        if (recognizeOptions.inactivityTimeout() != null) {
            builder.query(new Object[]{"inactivity_timeout", String.valueOf(recognizeOptions.inactivityTimeout())});
        }
        if (recognizeOptions.keywords() != null) {
            builder.query(new Object[]{"keywords", RequestUtils.join(recognizeOptions.keywords(), (String)",")});
        }
        if (recognizeOptions.keywordsThreshold() != null) {
            builder.query(new Object[]{"keywords_threshold", String.valueOf(recognizeOptions.keywordsThreshold())});
        }
        if (recognizeOptions.maxAlternatives() != null) {
            builder.query(new Object[]{"max_alternatives", String.valueOf(recognizeOptions.maxAlternatives())});
        }
        if (recognizeOptions.wordAlternativesThreshold() != null) {
            builder.query(new Object[]{"word_alternatives_threshold", String.valueOf(recognizeOptions.wordAlternativesThreshold())});
        }
        if (recognizeOptions.wordConfidence() != null) {
            builder.query(new Object[]{"word_confidence", String.valueOf(recognizeOptions.wordConfidence())});
        }
        if (recognizeOptions.timestamps() != null) {
            builder.query(new Object[]{"timestamps", String.valueOf(recognizeOptions.timestamps())});
        }
        if (recognizeOptions.profanityFilter() != null) {
            builder.query(new Object[]{"profanity_filter", String.valueOf(recognizeOptions.profanityFilter())});
        }
        if (recognizeOptions.smartFormatting() != null) {
            builder.query(new Object[]{"smart_formatting", String.valueOf(recognizeOptions.smartFormatting())});
        }
        if (recognizeOptions.speakerLabels() != null) {
            builder.query(new Object[]{"speaker_labels", String.valueOf(recognizeOptions.speakerLabels())});
        }
        if (recognizeOptions.customizationId() != null) {
            builder.query(new Object[]{"customization_id", recognizeOptions.customizationId()});
        }
        if (recognizeOptions.grammarName() != null) {
            builder.query(new Object[]{"grammar_name", recognizeOptions.grammarName()});
        }
        if (recognizeOptions.redaction() != null) {
            builder.query(new Object[]{"redaction", String.valueOf(recognizeOptions.redaction())});
        }
        if (recognizeOptions.audioMetrics() != null) {
            builder.query(new Object[]{"audio_metrics", String.valueOf(recognizeOptions.audioMetrics())});
        }
        if (recognizeOptions.endOfPhraseSilenceTime() != null) {
            builder.query(new Object[]{"end_of_phrase_silence_time", String.valueOf(recognizeOptions.endOfPhraseSilenceTime())});
        }
        if (recognizeOptions.splitTranscriptAtPhraseEnd() != null) {
            builder.query(new Object[]{"split_transcript_at_phrase_end", String.valueOf(recognizeOptions.splitTranscriptAtPhraseEnd())});
        }
        builder.bodyContent(recognizeOptions.contentType(), null, null, recognizeOptions.audio());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<SpeechRecognitionResults>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public WebSocket recognizeUsingWebSocket(RecognizeOptions recognizeOptions, RecognizeCallback callback) {
        Validator.notNull((Object)((Object)recognizeOptions), (String)"recognizeOptions cannot be null");
        Validator.notNull((Object)recognizeOptions.audio(), (String)"audio cannot be null");
        Validator.notNull((Object)callback, (String)"callback cannot be null");
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)(this.getServiceUrl() + "/v1/recognize")).newBuilder();
        if (recognizeOptions.model() != null) {
            urlBuilder.addQueryParameter("model", recognizeOptions.model());
        }
        if (recognizeOptions.customizationId() != null) {
            urlBuilder.addQueryParameter("customization_id", recognizeOptions.customizationId());
        }
        if (recognizeOptions.languageCustomizationId() != null) {
            urlBuilder.addQueryParameter("language_customization_id", recognizeOptions.languageCustomizationId());
        }
        if (recognizeOptions.acousticCustomizationId() != null) {
            urlBuilder.addQueryParameter("acoustic_customization_id", recognizeOptions.acousticCustomizationId());
        }
        if (recognizeOptions.baseModelVersion() != null) {
            urlBuilder.addQueryParameter("base_model_version", recognizeOptions.baseModelVersion());
        }
        String url = urlBuilder.toString().replace("https://", "wss://");
        Request.Builder builder = new Request.Builder().url(url);
        this.setAuthentication(builder);
        this.setDefaultHeaders(builder);
        OkHttpClient client = this.configureHttpClient();
        return client.newWebSocket(builder.build(), (WebSocketListener)new SpeechToTextWebSocketListener(recognizeOptions, callback));
    }

    public ServiceCall<RegisterStatus> registerCallback(RegisterCallbackOptions registerCallbackOptions) {
        Validator.notNull((Object)((Object)registerCallbackOptions), (String)"registerCallbackOptions cannot be null");
        String[] pathSegments = new String[]{"v1/register_callback"};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"registerCallback");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.query(new Object[]{"callback_url", registerCallbackOptions.callbackUrl()});
        if (registerCallbackOptions.userSecret() != null) {
            builder.query(new Object[]{"user_secret", registerCallbackOptions.userSecret()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<RegisterStatus>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> unregisterCallback(UnregisterCallbackOptions unregisterCallbackOptions) {
        Validator.notNull((Object)((Object)unregisterCallbackOptions), (String)"unregisterCallbackOptions cannot be null");
        String[] pathSegments = new String[]{"v1/unregister_callback"};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"unregisterCallback");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.query(new Object[]{"callback_url", unregisterCallbackOptions.callbackUrl()});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<RecognitionJob> createJob(CreateJobOptions createJobOptions) {
        Validator.notNull((Object)((Object)createJobOptions), (String)"createJobOptions cannot be null");
        String[] pathSegments = new String[]{"v1/recognitions"};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"createJob");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (createJobOptions.contentType() != null) {
            builder.header(new Object[]{"Content-Type", createJobOptions.contentType()});
        }
        if (createJobOptions.model() != null) {
            builder.query(new Object[]{"model", createJobOptions.model()});
        }
        if (createJobOptions.callbackUrl() != null) {
            builder.query(new Object[]{"callback_url", createJobOptions.callbackUrl()});
        }
        if (createJobOptions.events() != null) {
            builder.query(new Object[]{"events", createJobOptions.events()});
        }
        if (createJobOptions.userToken() != null) {
            builder.query(new Object[]{"user_token", createJobOptions.userToken()});
        }
        if (createJobOptions.resultsTtl() != null) {
            builder.query(new Object[]{"results_ttl", String.valueOf(createJobOptions.resultsTtl())});
        }
        if (createJobOptions.languageCustomizationId() != null) {
            builder.query(new Object[]{"language_customization_id", createJobOptions.languageCustomizationId()});
        }
        if (createJobOptions.acousticCustomizationId() != null) {
            builder.query(new Object[]{"acoustic_customization_id", createJobOptions.acousticCustomizationId()});
        }
        if (createJobOptions.baseModelVersion() != null) {
            builder.query(new Object[]{"base_model_version", createJobOptions.baseModelVersion()});
        }
        if (createJobOptions.customizationWeight() != null) {
            builder.query(new Object[]{"customization_weight", String.valueOf(createJobOptions.customizationWeight())});
        }
        if (createJobOptions.inactivityTimeout() != null) {
            builder.query(new Object[]{"inactivity_timeout", String.valueOf(createJobOptions.inactivityTimeout())});
        }
        if (createJobOptions.keywords() != null) {
            builder.query(new Object[]{"keywords", RequestUtils.join(createJobOptions.keywords(), (String)",")});
        }
        if (createJobOptions.keywordsThreshold() != null) {
            builder.query(new Object[]{"keywords_threshold", String.valueOf(createJobOptions.keywordsThreshold())});
        }
        if (createJobOptions.maxAlternatives() != null) {
            builder.query(new Object[]{"max_alternatives", String.valueOf(createJobOptions.maxAlternatives())});
        }
        if (createJobOptions.wordAlternativesThreshold() != null) {
            builder.query(new Object[]{"word_alternatives_threshold", String.valueOf(createJobOptions.wordAlternativesThreshold())});
        }
        if (createJobOptions.wordConfidence() != null) {
            builder.query(new Object[]{"word_confidence", String.valueOf(createJobOptions.wordConfidence())});
        }
        if (createJobOptions.timestamps() != null) {
            builder.query(new Object[]{"timestamps", String.valueOf(createJobOptions.timestamps())});
        }
        if (createJobOptions.profanityFilter() != null) {
            builder.query(new Object[]{"profanity_filter", String.valueOf(createJobOptions.profanityFilter())});
        }
        if (createJobOptions.smartFormatting() != null) {
            builder.query(new Object[]{"smart_formatting", String.valueOf(createJobOptions.smartFormatting())});
        }
        if (createJobOptions.speakerLabels() != null) {
            builder.query(new Object[]{"speaker_labels", String.valueOf(createJobOptions.speakerLabels())});
        }
        if (createJobOptions.customizationId() != null) {
            builder.query(new Object[]{"customization_id", createJobOptions.customizationId()});
        }
        if (createJobOptions.grammarName() != null) {
            builder.query(new Object[]{"grammar_name", createJobOptions.grammarName()});
        }
        if (createJobOptions.redaction() != null) {
            builder.query(new Object[]{"redaction", String.valueOf(createJobOptions.redaction())});
        }
        if (createJobOptions.processingMetrics() != null) {
            builder.query(new Object[]{"processing_metrics", String.valueOf(createJobOptions.processingMetrics())});
        }
        if (createJobOptions.processingMetricsInterval() != null) {
            builder.query(new Object[]{"processing_metrics_interval", String.valueOf(createJobOptions.processingMetricsInterval())});
        }
        if (createJobOptions.audioMetrics() != null) {
            builder.query(new Object[]{"audio_metrics", String.valueOf(createJobOptions.audioMetrics())});
        }
        if (createJobOptions.endOfPhraseSilenceTime() != null) {
            builder.query(new Object[]{"end_of_phrase_silence_time", String.valueOf(createJobOptions.endOfPhraseSilenceTime())});
        }
        if (createJobOptions.splitTranscriptAtPhraseEnd() != null) {
            builder.query(new Object[]{"split_transcript_at_phrase_end", String.valueOf(createJobOptions.splitTranscriptAtPhraseEnd())});
        }
        builder.bodyContent(createJobOptions.contentType(), null, null, createJobOptions.audio());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<RecognitionJob>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<RecognitionJobs> checkJobs(CheckJobsOptions checkJobsOptions) {
        String[] pathSegments = new String[]{"v1/recognitions"};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"checkJobs");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (checkJobsOptions != null) {
            // empty if block
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<RecognitionJobs>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<RecognitionJobs> checkJobs() {
        return this.checkJobs(null);
    }

    public ServiceCall<RecognitionJob> checkJob(CheckJobOptions checkJobOptions) {
        Validator.notNull((Object)((Object)checkJobOptions), (String)"checkJobOptions cannot be null");
        String[] pathSegments = new String[]{"v1/recognitions"};
        String[] pathParameters = new String[]{checkJobOptions.id()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"checkJob");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<RecognitionJob>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteJob(DeleteJobOptions deleteJobOptions) {
        Validator.notNull((Object)((Object)deleteJobOptions), (String)"deleteJobOptions cannot be null");
        String[] pathSegments = new String[]{"v1/recognitions"};
        String[] pathParameters = new String[]{deleteJobOptions.id()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"deleteJob");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<LanguageModel> createLanguageModel(CreateLanguageModelOptions createLanguageModelOptions) {
        Validator.notNull((Object)((Object)createLanguageModelOptions), (String)"createLanguageModelOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations"};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"createLanguageModel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("name", createLanguageModelOptions.name());
        contentJson.addProperty("base_model_name", createLanguageModelOptions.baseModelName());
        if (createLanguageModelOptions.dialect() != null) {
            contentJson.addProperty("dialect", createLanguageModelOptions.dialect());
        }
        if (createLanguageModelOptions.description() != null) {
            contentJson.addProperty("description", createLanguageModelOptions.description());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<LanguageModel>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<LanguageModels> listLanguageModels(ListLanguageModelsOptions listLanguageModelsOptions) {
        String[] pathSegments = new String[]{"v1/customizations"};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"listLanguageModels");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (listLanguageModelsOptions != null && listLanguageModelsOptions.language() != null) {
            builder.query(new Object[]{"language", listLanguageModelsOptions.language()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<LanguageModels>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<LanguageModels> listLanguageModels() {
        return this.listLanguageModels(null);
    }

    public ServiceCall<LanguageModel> getLanguageModel(GetLanguageModelOptions getLanguageModelOptions) {
        Validator.notNull((Object)((Object)getLanguageModelOptions), (String)"getLanguageModelOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations"};
        String[] pathParameters = new String[]{getLanguageModelOptions.customizationId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getLanguageModel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<LanguageModel>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteLanguageModel(DeleteLanguageModelOptions deleteLanguageModelOptions) {
        Validator.notNull((Object)((Object)deleteLanguageModelOptions), (String)"deleteLanguageModelOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations"};
        String[] pathParameters = new String[]{deleteLanguageModelOptions.customizationId()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"deleteLanguageModel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<TrainingResponse> trainLanguageModel(TrainLanguageModelOptions trainLanguageModelOptions) {
        Validator.notNull((Object)((Object)trainLanguageModelOptions), (String)"trainLanguageModelOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations", "train"};
        String[] pathParameters = new String[]{trainLanguageModelOptions.customizationId()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"trainLanguageModel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (trainLanguageModelOptions.wordTypeToAdd() != null) {
            builder.query(new Object[]{"word_type_to_add", trainLanguageModelOptions.wordTypeToAdd()});
        }
        if (trainLanguageModelOptions.customizationWeight() != null) {
            builder.query(new Object[]{"customization_weight", String.valueOf(trainLanguageModelOptions.customizationWeight())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<TrainingResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> resetLanguageModel(ResetLanguageModelOptions resetLanguageModelOptions) {
        Validator.notNull((Object)((Object)resetLanguageModelOptions), (String)"resetLanguageModelOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations", "reset"};
        String[] pathParameters = new String[]{resetLanguageModelOptions.customizationId()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"resetLanguageModel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> upgradeLanguageModel(UpgradeLanguageModelOptions upgradeLanguageModelOptions) {
        Validator.notNull((Object)((Object)upgradeLanguageModelOptions), (String)"upgradeLanguageModelOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations", "upgrade_model"};
        String[] pathParameters = new String[]{upgradeLanguageModelOptions.customizationId()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"upgradeLanguageModel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Corpora> listCorpora(ListCorporaOptions listCorporaOptions) {
        Validator.notNull((Object)((Object)listCorporaOptions), (String)"listCorporaOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations", "corpora"};
        String[] pathParameters = new String[]{listCorporaOptions.customizationId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"listCorpora");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Corpora>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> addCorpus(AddCorpusOptions addCorpusOptions) {
        Validator.notNull((Object)((Object)addCorpusOptions), (String)"addCorpusOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations", "corpora"};
        String[] pathParameters = new String[]{addCorpusOptions.customizationId(), addCorpusOptions.corpusName()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"addCorpus");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (addCorpusOptions.allowOverwrite() != null) {
            builder.query(new Object[]{"allow_overwrite", String.valueOf(addCorpusOptions.allowOverwrite())});
        }
        builder.body(RequestUtils.inputStreamBody((InputStream)addCorpusOptions.corpusFile(), (String)"text/plain"));
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Corpus> getCorpus(GetCorpusOptions getCorpusOptions) {
        Validator.notNull((Object)((Object)getCorpusOptions), (String)"getCorpusOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations", "corpora"};
        String[] pathParameters = new String[]{getCorpusOptions.customizationId(), getCorpusOptions.corpusName()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getCorpus");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Corpus>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteCorpus(DeleteCorpusOptions deleteCorpusOptions) {
        Validator.notNull((Object)((Object)deleteCorpusOptions), (String)"deleteCorpusOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations", "corpora"};
        String[] pathParameters = new String[]{deleteCorpusOptions.customizationId(), deleteCorpusOptions.corpusName()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"deleteCorpus");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Words> listWords(ListWordsOptions listWordsOptions) {
        Validator.notNull((Object)((Object)listWordsOptions), (String)"listWordsOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations", "words"};
        String[] pathParameters = new String[]{listWordsOptions.customizationId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"listWords");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (listWordsOptions.wordType() != null) {
            builder.query(new Object[]{"word_type", listWordsOptions.wordType()});
        }
        if (listWordsOptions.sort() != null) {
            builder.query(new Object[]{"sort", listWordsOptions.sort()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Words>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> addWords(AddWordsOptions addWordsOptions) {
        Validator.notNull((Object)((Object)addWordsOptions), (String)"addWordsOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations", "words"};
        String[] pathParameters = new String[]{addWordsOptions.customizationId()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"addWords");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        contentJson.add("words", GsonSingleton.getGson().toJsonTree(addWordsOptions.words()));
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> addWord(AddWordOptions addWordOptions) {
        Validator.notNull((Object)((Object)addWordOptions), (String)"addWordOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations", "words"};
        String[] pathParameters = new String[]{addWordOptions.customizationId(), addWordOptions.wordName()};
        RequestBuilder builder = RequestBuilder.put((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"addWord");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        if (addWordOptions.word() != null) {
            contentJson.addProperty("word", addWordOptions.word());
        }
        if (addWordOptions.soundsLike() != null) {
            contentJson.add("sounds_like", GsonSingleton.getGson().toJsonTree(addWordOptions.soundsLike()));
        }
        if (addWordOptions.displayAs() != null) {
            contentJson.addProperty("display_as", addWordOptions.displayAs());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Word> getWord(GetWordOptions getWordOptions) {
        Validator.notNull((Object)((Object)getWordOptions), (String)"getWordOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations", "words"};
        String[] pathParameters = new String[]{getWordOptions.customizationId(), getWordOptions.wordName()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getWord");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Word>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteWord(DeleteWordOptions deleteWordOptions) {
        Validator.notNull((Object)((Object)deleteWordOptions), (String)"deleteWordOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations", "words"};
        String[] pathParameters = new String[]{deleteWordOptions.customizationId(), deleteWordOptions.wordName()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"deleteWord");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Grammars> listGrammars(ListGrammarsOptions listGrammarsOptions) {
        Validator.notNull((Object)((Object)listGrammarsOptions), (String)"listGrammarsOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations", "grammars"};
        String[] pathParameters = new String[]{listGrammarsOptions.customizationId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"listGrammars");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Grammars>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> addGrammar(AddGrammarOptions addGrammarOptions) {
        Validator.notNull((Object)((Object)addGrammarOptions), (String)"addGrammarOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations", "grammars"};
        String[] pathParameters = new String[]{addGrammarOptions.customizationId(), addGrammarOptions.grammarName()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"addGrammar");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        builder.header(new Object[]{"Content-Type", addGrammarOptions.contentType()});
        if (addGrammarOptions.allowOverwrite() != null) {
            builder.query(new Object[]{"allow_overwrite", String.valueOf(addGrammarOptions.allowOverwrite())});
        }
        builder.bodyContent(addGrammarOptions.contentType(), null, null, addGrammarOptions.grammarFile());
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Grammar> getGrammar(GetGrammarOptions getGrammarOptions) {
        Validator.notNull((Object)((Object)getGrammarOptions), (String)"getGrammarOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations", "grammars"};
        String[] pathParameters = new String[]{getGrammarOptions.customizationId(), getGrammarOptions.grammarName()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getGrammar");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<Grammar>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteGrammar(DeleteGrammarOptions deleteGrammarOptions) {
        Validator.notNull((Object)((Object)deleteGrammarOptions), (String)"deleteGrammarOptions cannot be null");
        String[] pathSegments = new String[]{"v1/customizations", "grammars"};
        String[] pathParameters = new String[]{deleteGrammarOptions.customizationId(), deleteGrammarOptions.grammarName()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"deleteGrammar");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<AcousticModel> createAcousticModel(CreateAcousticModelOptions createAcousticModelOptions) {
        Validator.notNull((Object)((Object)createAcousticModelOptions), (String)"createAcousticModelOptions cannot be null");
        String[] pathSegments = new String[]{"v1/acoustic_customizations"};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"createAcousticModel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("name", createAcousticModelOptions.name());
        contentJson.addProperty("base_model_name", createAcousticModelOptions.baseModelName());
        if (createAcousticModelOptions.description() != null) {
            contentJson.addProperty("description", createAcousticModelOptions.description());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<AcousticModel>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<AcousticModels> listAcousticModels(ListAcousticModelsOptions listAcousticModelsOptions) {
        String[] pathSegments = new String[]{"v1/acoustic_customizations"};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"listAcousticModels");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (listAcousticModelsOptions != null && listAcousticModelsOptions.language() != null) {
            builder.query(new Object[]{"language", listAcousticModelsOptions.language()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<AcousticModels>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<AcousticModels> listAcousticModels() {
        return this.listAcousticModels(null);
    }

    public ServiceCall<AcousticModel> getAcousticModel(GetAcousticModelOptions getAcousticModelOptions) {
        Validator.notNull((Object)((Object)getAcousticModelOptions), (String)"getAcousticModelOptions cannot be null");
        String[] pathSegments = new String[]{"v1/acoustic_customizations"};
        String[] pathParameters = new String[]{getAcousticModelOptions.customizationId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getAcousticModel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<AcousticModel>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteAcousticModel(DeleteAcousticModelOptions deleteAcousticModelOptions) {
        Validator.notNull((Object)((Object)deleteAcousticModelOptions), (String)"deleteAcousticModelOptions cannot be null");
        String[] pathSegments = new String[]{"v1/acoustic_customizations"};
        String[] pathParameters = new String[]{deleteAcousticModelOptions.customizationId()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"deleteAcousticModel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<TrainingResponse> trainAcousticModel(TrainAcousticModelOptions trainAcousticModelOptions) {
        Validator.notNull((Object)((Object)trainAcousticModelOptions), (String)"trainAcousticModelOptions cannot be null");
        String[] pathSegments = new String[]{"v1/acoustic_customizations", "train"};
        String[] pathParameters = new String[]{trainAcousticModelOptions.customizationId()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"trainAcousticModel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (trainAcousticModelOptions.customLanguageModelId() != null) {
            builder.query(new Object[]{"custom_language_model_id", trainAcousticModelOptions.customLanguageModelId()});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<TrainingResponse>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> resetAcousticModel(ResetAcousticModelOptions resetAcousticModelOptions) {
        Validator.notNull((Object)((Object)resetAcousticModelOptions), (String)"resetAcousticModelOptions cannot be null");
        String[] pathSegments = new String[]{"v1/acoustic_customizations", "reset"};
        String[] pathParameters = new String[]{resetAcousticModelOptions.customizationId()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"resetAcousticModel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> upgradeAcousticModel(UpgradeAcousticModelOptions upgradeAcousticModelOptions) {
        Validator.notNull((Object)((Object)upgradeAcousticModelOptions), (String)"upgradeAcousticModelOptions cannot be null");
        String[] pathSegments = new String[]{"v1/acoustic_customizations", "upgrade_model"};
        String[] pathParameters = new String[]{upgradeAcousticModelOptions.customizationId()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"upgradeAcousticModel");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (upgradeAcousticModelOptions.customLanguageModelId() != null) {
            builder.query(new Object[]{"custom_language_model_id", upgradeAcousticModelOptions.customLanguageModelId()});
        }
        if (upgradeAcousticModelOptions.force() != null) {
            builder.query(new Object[]{"force", String.valueOf(upgradeAcousticModelOptions.force())});
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<AudioResources> listAudio(ListAudioOptions listAudioOptions) {
        Validator.notNull((Object)((Object)listAudioOptions), (String)"listAudioOptions cannot be null");
        String[] pathSegments = new String[]{"v1/acoustic_customizations", "audio"};
        String[] pathParameters = new String[]{listAudioOptions.customizationId()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"listAudio");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<AudioResources>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> addAudio(AddAudioOptions addAudioOptions) {
        Validator.notNull((Object)((Object)addAudioOptions), (String)"addAudioOptions cannot be null");
        String[] pathSegments = new String[]{"v1/acoustic_customizations", "audio"};
        String[] pathParameters = new String[]{addAudioOptions.customizationId(), addAudioOptions.audioName()};
        RequestBuilder builder = RequestBuilder.post((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"addAudio");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        if (addAudioOptions.contentType() != null) {
            builder.header(new Object[]{"Content-Type", addAudioOptions.contentType()});
        }
        if (addAudioOptions.containedContentType() != null) {
            builder.header(new Object[]{"Contained-Content-Type", addAudioOptions.containedContentType()});
        }
        if (addAudioOptions.allowOverwrite() != null) {
            builder.query(new Object[]{"allow_overwrite", String.valueOf(addAudioOptions.allowOverwrite())});
        }
        builder.bodyContent(addAudioOptions.contentType(), null, null, addAudioOptions.audioResource());
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<AudioListing> getAudio(GetAudioOptions getAudioOptions) {
        Validator.notNull((Object)((Object)getAudioOptions), (String)"getAudioOptions cannot be null");
        String[] pathSegments = new String[]{"v1/acoustic_customizations", "audio"};
        String[] pathParameters = new String[]{getAudioOptions.customizationId(), getAudioOptions.audioName()};
        RequestBuilder builder = RequestBuilder.get((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"getAudio");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getValue((Type)new TypeToken<AudioListing>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteAudio(DeleteAudioOptions deleteAudioOptions) {
        Validator.notNull((Object)((Object)deleteAudioOptions), (String)"deleteAudioOptions cannot be null");
        String[] pathSegments = new String[]{"v1/acoustic_customizations", "audio"};
        String[] pathParameters = new String[]{deleteAudioOptions.customizationId(), deleteAudioOptions.audioName()};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments, (String[])pathParameters));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"deleteAudio");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.header(new Object[]{"Accept", "application/json"});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> deleteUserData(DeleteUserDataOptions deleteUserDataOptions) {
        Validator.notNull((Object)((Object)deleteUserDataOptions), (String)"deleteUserDataOptions cannot be null");
        String[] pathSegments = new String[]{"v1/user_data"};
        RequestBuilder builder = RequestBuilder.delete((HttpUrl)RequestBuilder.constructHttpUrl((String)this.getServiceUrl(), (String[])pathSegments));
        Map sdkHeaders = SdkCommon.getSdkHeaders((String)DEFAULT_SERVICE_NAME, (String)"v1", (String)"deleteUserData");
        for (Map.Entry header : sdkHeaders.entrySet()) {
            builder.header(new Object[]{header.getKey(), header.getValue()});
        }
        builder.query(new Object[]{"customer_id", deleteUserDataOptions.customerId()});
        ResponseConverter responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }
}

