/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.speech_to_text.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class AddGrammarOptions
extends GenericModel {
    protected String customizationId;
    protected String grammarName;
    protected InputStream grammarFile;
    protected String contentType;
    protected Boolean allowOverwrite;

    protected AddGrammarOptions(Builder builder) {
        Validator.notEmpty((String)builder.customizationId, (String)"customizationId cannot be empty");
        Validator.notEmpty((String)builder.grammarName, (String)"grammarName cannot be empty");
        Validator.notNull((Object)builder.grammarFile, (String)"grammarFile cannot be null");
        Validator.notNull((Object)builder.contentType, (String)"contentType cannot be null");
        this.customizationId = builder.customizationId;
        this.grammarName = builder.grammarName;
        this.grammarFile = builder.grammarFile;
        this.contentType = builder.contentType;
        this.allowOverwrite = builder.allowOverwrite;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String customizationId() {
        return this.customizationId;
    }

    public String grammarName() {
        return this.grammarName;
    }

    public InputStream grammarFile() {
        return this.grammarFile;
    }

    public String contentType() {
        return this.contentType;
    }

    public Boolean allowOverwrite() {
        return this.allowOverwrite;
    }

    public static class Builder {
        private String customizationId;
        private String grammarName;
        private InputStream grammarFile;
        private String contentType;
        private Boolean allowOverwrite;

        private Builder(AddGrammarOptions addGrammarOptions) {
            this.customizationId = addGrammarOptions.customizationId;
            this.grammarName = addGrammarOptions.grammarName;
            this.grammarFile = addGrammarOptions.grammarFile;
            this.contentType = addGrammarOptions.contentType;
            this.allowOverwrite = addGrammarOptions.allowOverwrite;
        }

        public Builder() {
        }

        public Builder(String customizationId, String grammarName, InputStream grammarFile, String contentType) {
            this.customizationId = customizationId;
            this.grammarName = grammarName;
            this.grammarFile = grammarFile;
            this.contentType = contentType;
        }

        public AddGrammarOptions build() {
            return new AddGrammarOptions(this);
        }

        public Builder customizationId(String customizationId) {
            this.customizationId = customizationId;
            return this;
        }

        public Builder grammarName(String grammarName) {
            this.grammarName = grammarName;
            return this;
        }

        public Builder grammarFile(InputStream grammarFile) {
            this.grammarFile = grammarFile;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder allowOverwrite(Boolean allowOverwrite) {
            this.allowOverwrite = allowOverwrite;
            return this;
        }

        public Builder grammarFile(File grammarFile) throws FileNotFoundException {
            this.grammarFile = new FileInputStream(grammarFile);
            return this;
        }
    }
}

