/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.text_to_speech.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.text_to_speech.v1.model.PromptMetadata;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class AddCustomPromptOptions
extends GenericModel {
    protected String customizationId;
    protected String promptId;
    protected PromptMetadata metadata;
    protected InputStream file;

    protected AddCustomPromptOptions() {
    }

    protected AddCustomPromptOptions(Builder builder) {
        Validator.notEmpty((String)builder.customizationId, (String)"customizationId cannot be empty");
        Validator.notEmpty((String)builder.promptId, (String)"promptId cannot be empty");
        Validator.notNull((Object)((Object)builder.metadata), (String)"metadata cannot be null");
        Validator.notNull((Object)builder.file, (String)"file cannot be null");
        this.customizationId = builder.customizationId;
        this.promptId = builder.promptId;
        this.metadata = builder.metadata;
        this.file = builder.file;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String customizationId() {
        return this.customizationId;
    }

    public String promptId() {
        return this.promptId;
    }

    public PromptMetadata metadata() {
        return this.metadata;
    }

    public InputStream file() {
        return this.file;
    }

    public static class Builder {
        private String customizationId;
        private String promptId;
        private PromptMetadata metadata;
        private InputStream file;

        private Builder(AddCustomPromptOptions addCustomPromptOptions) {
            this.customizationId = addCustomPromptOptions.customizationId;
            this.promptId = addCustomPromptOptions.promptId;
            this.metadata = addCustomPromptOptions.metadata;
            this.file = addCustomPromptOptions.file;
        }

        public Builder() {
        }

        public Builder(String customizationId, String promptId, PromptMetadata metadata, InputStream file) {
            this.customizationId = customizationId;
            this.promptId = promptId;
            this.metadata = metadata;
            this.file = file;
        }

        public AddCustomPromptOptions build() {
            return new AddCustomPromptOptions(this);
        }

        public Builder customizationId(String customizationId) {
            this.customizationId = customizationId;
            return this;
        }

        public Builder promptId(String promptId) {
            this.promptId = promptId;
            return this;
        }

        public Builder metadata(PromptMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder file(InputStream file) {
            this.file = file;
            return this;
        }

        public Builder file(File file) throws FileNotFoundException {
            this.file = new FileInputStream(file);
            return this;
        }
    }
}

