/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.text_to_speech.v1.websocket;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.ibm.cloud.sdk.core.util.GsonSingleton;
import com.ibm.watson.text_to_speech.v1.model.Marks;
import com.ibm.watson.text_to_speech.v1.model.SynthesizeOptions;
import com.ibm.watson.text_to_speech.v1.model.Timings;
import com.ibm.watson.text_to_speech.v1.websocket.SynthesizeCallback;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;

public class TextToSpeechWebSocketListener
extends WebSocketListener {
    private static final String TEXT_TO_WEB_SOCKET = "TextToWebSocketThread";
    private static final Gson GSON = GsonSingleton.getGsonWithoutPrettyPrinting();
    private static final Logger LOG = Logger.getLogger(TextToSpeechWebSocketListener.class.getName());
    private static final String VOICE = "voice";
    private static final String CUSTOMIZATION_ID = "customization_id";
    private static final String SPELL_OUT_MODE = "spell_out_mode";
    private static final String ACTION = "action";
    private static final String START = "start";
    private static final String STOP = "stop";
    private static final String ERROR = "error";
    private static final String WARNINGS = "warnings";
    private static final String BINARY_STREAMS = "binary_streams";
    private static final String CONTENT_TYPE = "content_type";
    private static final String WORDS = "words";
    private static final String MARKS = "marks";
    private final SynthesizeOptions options;
    private final SynthesizeCallback callback;
    private WebSocket socket;
    private boolean socketOpen = true;

    public TextToSpeechWebSocketListener(SynthesizeOptions options, SynthesizeCallback callback) {
        this.options = options;
        this.callback = callback;
    }

    public void onClosing(WebSocket webSocket, int code, String reason) {
        this.socketOpen = false;
        this.callback.onDisconnected();
    }

    public void onFailure(WebSocket webSocket, Throwable t, Response response) {
        this.socketOpen = false;
        if (t instanceof Exception) {
            this.callback.onError((Exception)t);
        } else {
            this.callback.onError(new Exception(t));
        }
    }

    public void onMessage(WebSocket webSocket, String message) {
        JsonObject json = new JsonParser().parse(message).getAsJsonObject();
        if (json.has(ERROR)) {
            String error = json.get(ERROR).getAsString();
            this.callback.onError(new RuntimeException(error));
        } else if (json.has(WARNINGS)) {
            String warning = json.get(WARNINGS).getAsString();
            this.callback.onWarning(new RuntimeException(warning));
        } else if (json.has(BINARY_STREAMS)) {
            String contentType = json.get(BINARY_STREAMS).getAsJsonArray().get(0).getAsJsonObject().get(CONTENT_TYPE).getAsString();
            this.callback.onContentType(contentType);
        } else if (json.has(WORDS)) {
            this.callback.onTimings((Timings)((Object)GSON.fromJson(message, Timings.class)));
        } else if (json.has(MARKS)) {
            this.callback.onMarks((Marks)((Object)GSON.fromJson(message, Marks.class)));
        }
    }

    public void onMessage(WebSocket webSocket, ByteString bytes) {
        this.callback.onAudioStream(bytes.toByteArray());
    }

    public void onOpen(WebSocket webSocket, Response response) {
        this.callback.onConnected();
        this.socket = webSocket;
        if (!this.socket.send(this.buildStartMessage(this.options))) {
            this.callback.onError(new IOException("WebSocket unavailable"));
        } else {
            new Thread(TEXT_TO_WEB_SOCKET){

                @Override
                public void run() {
                    TextToSpeechWebSocketListener.this.sendText();
                    if (TextToSpeechWebSocketListener.this.socketOpen && !TextToSpeechWebSocketListener.this.socket.send(TextToSpeechWebSocketListener.this.buildStopMessage())) {
                        LOG.log(Level.SEVERE, "Stop message discarded because WebSocket is unavailable");
                    }
                }
            };
        }
    }

    private void sendText() {
        try {
            while (this.socketOpen) {
                this.socket.send(this.options.text());
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private String buildStartMessage(SynthesizeOptions options) {
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        JsonObject startMessage = new JsonParser().parse(gson.toJson((Object)options)).getAsJsonObject();
        startMessage.remove(VOICE);
        startMessage.remove(CUSTOMIZATION_ID);
        startMessage.remove(SPELL_OUT_MODE);
        startMessage.addProperty(ACTION, START);
        return startMessage.toString();
    }

    private String buildStopMessage() {
        JsonObject stopMessage = new JsonObject();
        stopMessage.addProperty(ACTION, STOP);
        return stopMessage.toString();
    }
}

