/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.text_to_speech.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import com.ibm.watson.text_to_speech.v1.model.Word;
import java.util.ArrayList;
import java.util.List;

public class UpdateVoiceModelOptions
extends GenericModel {
    private String customizationId;
    private String name;
    private String description;
    private List<Word> words;

    private UpdateVoiceModelOptions(Builder builder) {
        Validator.notEmpty((String)builder.customizationId, (String)"customizationId cannot be empty");
        this.customizationId = builder.customizationId;
        this.name = builder.name;
        this.description = builder.description;
        this.words = builder.words;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String customizationId() {
        return this.customizationId;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public List<Word> words() {
        return this.words;
    }

    public static class Builder {
        private String customizationId;
        private String name;
        private String description;
        private List<Word> words;

        private Builder(UpdateVoiceModelOptions updateVoiceModelOptions) {
            this.customizationId = updateVoiceModelOptions.customizationId;
            this.name = updateVoiceModelOptions.name;
            this.description = updateVoiceModelOptions.description;
            this.words = updateVoiceModelOptions.words;
        }

        public Builder() {
        }

        public Builder(String customizationId) {
            this.customizationId = customizationId;
        }

        public UpdateVoiceModelOptions build() {
            return new UpdateVoiceModelOptions(this);
        }

        public Builder addWord(Word word) {
            Validator.notNull((Object)((Object)word), (String)"word cannot be null");
            if (this.words == null) {
                this.words = new ArrayList<Word>();
            }
            this.words.add(word);
            return this;
        }

        public Builder customizationId(String customizationId) {
            this.customizationId = customizationId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder words(List<Word> words) {
            this.words = words;
            return this;
        }
    }
}

