/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.text_to_speech.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class CreateCustomModelOptions
extends GenericModel {
    protected String name;
    protected String language;
    protected String description;

    protected CreateCustomModelOptions(Builder builder) {
        Validator.notNull((Object)builder.name, (String)"name cannot be null");
        this.name = builder.name;
        this.language = builder.language;
        this.description = builder.description;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String name() {
        return this.name;
    }

    public String language() {
        return this.language;
    }

    public String description() {
        return this.description;
    }

    public static class Builder {
        private String name;
        private String language;
        private String description;

        private Builder(CreateCustomModelOptions createCustomModelOptions) {
            this.name = createCustomModelOptions.name;
            this.language = createCustomModelOptions.language;
            this.description = createCustomModelOptions.description;
        }

        public Builder() {
        }

        public Builder(String name) {
            this.name = name;
        }

        public CreateCustomModelOptions build() {
            return new CreateCustomModelOptions(this);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }
    }

    public static interface Language {
        public static final String AR_MS = "ar-MS";
        public static final String DE_DE = "de-DE";
        public static final String EN_GB = "en-GB";
        public static final String EN_US = "en-US";
        public static final String ES_ES = "es-ES";
        public static final String ES_LA = "es-LA";
        public static final String ES_US = "es-US";
        public static final String FR_CA = "fr-CA";
        public static final String FR_FR = "fr-FR";
        public static final String IT_IT = "it-IT";
        public static final String JA_JP = "ja-JP";
        public static final String KO_KR = "ko-KR";
        public static final String NL_NL = "nl-NL";
        public static final String PT_BR = "pt-BR";
        public static final String ZH_CN = "zh-CN";
    }
}

